import { ApiResponse } from "@/@types/api";
import {
  SendTicketData,
  SendTicketMessage,
  TicketType,
} from "@/@types/tickets";
import { api } from "@/configs/api";

const sendTicket = (data: SendTicketData) => api.post("user/sendTicket", data);
const sendTicketMessage = (data: SendTicketMessage) =>
  api.post("user/sendmessage", data);

// const getTicket = (id: string) => {
//   api.post(`user/sendticket/${id}`);
// };

const getTicket = async (id: string): Promise<ApiResponse<TicketType>> => {
  const res = await api.get<ApiResponse<TicketType>>(`user/sendticket/${id}`);
  return res.data;
};

const getTicketsAdmin = () => api.get("/admin/ticket");
const sendAdminTicketMessage = (data: SendTicketMessage) =>
  api.post("admin/adminReply", data);

const updateTicketsStatus = (id: string) => api.put(`admin/statustick/${id}`);

export {
  sendTicket,
  sendTicketMessage,
  getTicket,
  getTicketsAdmin,
  sendAdminTicketMessage,
  updateTicketsStatus,
};
