import { api } from "@/configs/api";

const getUserFiles = () => api.get("/user/file");

const getFiles = () => api.get("admin/file");
const getFileDetails = (id: string) => api.get(`admin/file/${id}`);
const sendAdminFile = (data: FormData) => api.post("/admin/create/file", data);

const updateAdminFile = ({ id, data }: { id: string; data: FormData }) =>
  api.put(`/admin/update/file/${id}`, data);

const updateAdminFileStatus = ({
  id,
  isaccept,
}: {
  id: string;
  isaccept: boolean;
}) => api.put(`admin/update/file/${id}`, { isaccept });

const deleteFile = (id: string) => api.delete(`/admin/delete/file/${id}`);

export {
  getUserFiles,
  getFiles,
  getFileDetails,
  sendAdminFile,
  updateAdminFile,
  updateAdminFileStatus,
  deleteFile,
};
