import { DevType } from "@/@types/dev";
import { api } from "@/configs/api";

const sendDevInfo = (data: DevType) => api.post("user/dev/apply", data);
const updateDevInfo = (data: DevType) => api.put("user/dev/edit", data);

const getDevInfo = async () => api.get("user/dev/me");

const senDevDiscount = (data: {
  code: string;
  amount: number;
  usageLimit: number;
  expiry: string;
  fileid: string;
  usedCount: number;
}) => api.post("user/discounts/add", data);
const updateDevDiscount = (data: {
  code: string;
  amount: number;
  usageLimit: number;
  expiry: string;
  fileid: string;
  usedCount: number;
  id: string;
}) => {
  const { id, ...rest } = data;
  return api.put(`user/discounts/update/${id}`, rest);
};

const getDevDiscount = async () => api.get("user/discounts/list");

const deleteDevDiscount = async (id: string) =>
  api.delete(`user/discounts/delete/${id}`);

const getAdminDevList = async ({
  page,
  limit,
}: {
  page: number;
  limit: number;
}) => api.get(`admin/devs?page=${page}&limit=${limit}`);

const updateADminDevStatus = ({
  id,
  action,
  reason,
}: {
  id: string;
  action: string;
  reason: string;
}) => api.put(`admin/devs/${id}/decision`, { action, reason });

const deleteDevAccount = (id: string) => api.delete(`/admin/devs/${id}`);

export {
  sendDevInfo,
  updateDevInfo,
  getDevInfo,
  senDevDiscount,
  updateDevDiscount,
  getDevDiscount,
  deleteDevDiscount,
  getAdminDevList,
  updateADminDevStatus,
  deleteDevAccount,
};
