import { api } from "@/configs/api";

const getAdminCategory = () => api.get("admin/category");
const getAdminCategoryById = (id: string) => api.get(`category/${id}`);
const getAdminSubCategoryById = (id: string) =>
  api.get(`admin/category/${id}/subcategory/edit`);

const getAdminSubSubCategory = ({
  catId,
  subId,
}: {
  catId: string;
  subId: string;
}) => api.get(`/admin/category/${catId}/subcategory/${subId}/subsubcategory`);

const getCategory = () => api.get("category");

const getSubCategory = (subCategoryId: string) =>
  api.get(`admin/category/${subCategoryId}/subcategory`);
const getSubCategoryById = (subCategoryId: string, catId: string) =>
  api.get(`admin/category/${catId}/subcategory/${subCategoryId}`);
const getAdminSubCategory = (catId: string) =>
  api.get(`
/admin/category/${catId}/subcategory`);

const getAdminSubSubCategoryById = (subSubId: string) =>
  api.get(`
/admin/category/{${subSubId}}/subsubcategory`);

const DeleteCategory = (id: string) =>
  api.delete(`admin/category/delete/${id}`);
const deleteSubCategory = ({
  catId,
  subId,
}: {
  catId: string;
  subId: string;
}) => api.delete(`/admin/category/${catId}/subcategory/delete/${subId}`);
const deleteSubSubCategory = ({
  catId,
  subId,
  subSubId,
}: {
  catId: string;
  subId: string;
  subSubId: string;
}) =>
  api.delete(
    `/admin/category/${catId}/subcategory/${subId}/subsubcategory/delete/${subSubId}`
  );
const sendCategory = (data: FormData) => api.post(`/admin/category`, data);
const sendSubCategory = ({ data, id }: { data: FormData; id: string }) =>
  api.post(`admin/category/${id}/subcategory`, data);

const sendSubSubCategory = ({
  catId,
  subId,
  data,
}: {
  catId: string;
  subId: string;
  data: FormData;
}) =>
  api.post(
    `/admin/category/${catId}/subcategory/${subId}/subsubcategory`,
    data
  );

const updateCategory = (data: FormData) =>
  api.post(`/admin/category/edit`, data);
const updateSubCategory = ({
  id,
  data,
}: {
  id: string;
  data: {
    categoryId: string;
    subId: string;
    title: string;
    href: string;
  };
}) => api.post(`admin/category/${id}/subcategory/edit`, data);
const updateSubSubCategory = ({
  catId,
  subId,
  data,
}: {
  catId: string;
  subId: string;
  data: {
    categoryId: "string";
    subId: string;
    title: string;
    href: string;
  };
}) =>
  api.post(
    `
/admin/category/${catId}/subcategory/${subId}/subsubcategory/edit
`,
    data
  );

export {
  getAdminCategory,
  getAdminCategoryById,
  getAdminSubCategoryById,
  getAdminSubSubCategory,
  getAdminSubSubCategoryById,
  DeleteCategory,
  deleteSubCategory,
  deleteSubSubCategory,
  sendCategory,
  sendSubCategory,
  sendSubSubCategory,
  updateCategory,
  updateSubCategory,
  updateSubSubCategory,
  getAdminSubCategory,
  getCategory,
  getSubCategory,
  getSubCategoryById,
};
