import { BankType } from "@/@types/Bank";
import { api } from "@/configs/api";

const sendBank = (data: BankType) => api.post("/user/bank/add", data);
const getBank = () => api.get("/user/bank");
const getAdminBanks = () => api.get("admin/cardbank/list");
const confirmUserBank = ({ id, bankid }: { id: string; bankid: string }) =>
  api.put(`admin/cardbank/approved/${id}`, { bankid });
const rejectUserBank = ({
  id,
  bankid,
  rejectedText,
}: {
  id: string;
  bankid: string;
  rejectedText: string;
}) => api.put(`admin/cardbank/rejected/${id}`, { bankid, rejectedText });
export { sendBank, getBank, getAdminBanks, confirmUserBank, rejectUserBank };
