import { AddDiscountType, UpdateDiscountType } from "@/@types/discount";
import { api } from "@/configs/api";

const usedDiscount = (code: string) =>
  api.post(`user/usedisconnect`, { discountcode: code });

const getDiscounts = () => api.get("admin/discounts");
const DeleteDiscount = (id: string) =>
  api.delete(`/admin/discounts/delete/${id}`);

const addDiscount = (data: AddDiscountType) =>
  api.post("admin/discounts/add", data);
const updateDiscount = (data: UpdateDiscountType) =>
  api.put("/admin/discounts/update", data);

export {
  usedDiscount,
  addDiscount,
  getDiscounts,
  DeleteDiscount,
  updateDiscount,
};
