import { api } from "@/configs/api";

const sendComment = (data: { text: string; fileid: string }) =>
  api.post(`user/comment/create`, data);

const sendReplayComment = (data: {
  text: string;
  fileid: string;
  commentId: string;
}) => api.post(`user/comment/reply`, data);

const experiencesComments = () => api.get("admin/comment/showpage");

const getAdminComments = () => api.get("admin/comment");
const acceptComment = ({ fileid, id }: { fileid: string; id: string }) =>
  api.put(`admin/comment/${fileid}/${id}`);
const rejectComment = ({ fileid, id }: { fileid: string; id: string }) =>
  api.put(`admin/comment/rejected/${fileid}/${id}`);

const addTopComment = ({ fileid, id }: { fileid: string; id: string }) =>
  api.put(`/admin/comment/show/page/${fileid}/${id}`);

const adminAnswerComment = ({
  fileid,
  commentId,
  text,
}: {
  fileid: string;
  commentId: string;
  text: string;
}) => api.post("admin/comment/reply", { fileid, commentId, text });

const getComments = () => api.get("comments");

export {
  sendComment,
  sendReplayComment,
  experiencesComments,
  getAdminComments,
  acceptComment,
  rejectComment,
  addTopComment,
  adminAnswerComment,
  getComments,
};
