import { api } from "@/configs/api";

const getLatestBlog = () => api.get("/blog/new");
// const getBlogs = (searchParams: string) => api.get(`blog/new`);
// const getBlogs = (searchParams: string) => api.get("blog");
const getBlogs = () => api.get("blog");
const getBlog = (slug: string) => api.get(`blog"${slug}`);

const getAdminBlogs = () => api.get("/admin/bloglist");
const getAdminBlogById = (id: string) => api.get(`/admin/editblog/${id}`);
const updateBlog = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("admin/editblogform", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};
const addBlog = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("admin/addblog", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};
const deleteAdminBlog = (id: string) => api.delete(`/admin/removeblog/${id}`);

const getAuthBlogs = () => api.get("/admin/bloglist");
const getAuthBlogById = (id: string) => api.get(`/admin/editblog/${id}`);

const updateAuthBlog = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("admin/editblogform", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};
const addAuthBlog = ({
  data,
  onProgress,
}: {
  data: FormData;
  onProgress?: (percent: number) => void;
}) => {
  return api.post("admin/addblog", data, {
    headers: {
      "Content-Type": "multipart/form-data",
    },
    onUploadProgress: (progressEvent) => {
      if (!progressEvent.total) return;

      const percent = Math.round(
        (progressEvent.loaded * 100) / progressEvent.total
      );

      onProgress?.(percent);
    },
  });
};

const deleteAuthBlog = (id: string) => api.delete(`/admin/removeblog/${id}`);

export {
  getLatestBlog,
  getBlogs,
  getBlog,
  getAdminBlogs,
  getAdminBlogById,
  updateBlog,
  addBlog,
  deleteAdminBlog,
  updateAuthBlog,
  getAuthBlogs,
  getAuthBlogById,
  addAuthBlog,
  deleteAuthBlog,
};
