import { UserAddressType } from "@/@types/user";
import { api } from "@/configs/api";

const sendPhone = (data: { phone: string }) => api.post("auth/login", data);

const userRegister = (data: {
  phone: string;
  username: string;
  email: string;
  password: string;
  fname: string;
  lname: string;
}) => api.post("auth/register", data);

const sendOtp = (data: { phone: string; otp: string }) =>
  api.post("auth/otp", data);

const getMe = () => api.get("user/profile");

const loginWithPassword = (data: { phone: string; password: string }) =>
  api.post("auth/loginpassword", data);

const sendUser = (data: {
  username?: string;
  email: string;
  codemeli: string;
  fname: string;
  lname: string;
  gender: "مرد" | "زن";
  datebirth: string;
  avatar: string;
}) => api.post("user/profile/1", data);
const sendUserAddress = (data: UserAddressType) =>
  api.post("user/profile/2", data);

export {
  sendPhone,
  userRegister,
  sendOtp,
  getMe,
  loginWithPassword,
  sendUser,
  sendUserAddress,
};
