import { getAccessToken } from "@/lib/token";
import axios from "axios";
const accessToken = getAccessToken();
const api = axios.create({
  baseURL: process.env.NEXT_PUBLIC_BASE_URL,
  withCredentials: true,
  headers: {
    // "Content-Type": "Application/json",
    Authorization: `Bearer ${accessToken ? accessToken : ""}`,
  },
});

api.interceptors.request.use((config) => {
  const accessToken = getAccessToken();
  if (accessToken) {
    config.headers.Authorization = `Bearer ${accessToken}`;
  }
  return config;
});

export { api };
