"use client";
import Image from "next/image";
import React, { useContext } from "react";
import UserNameField from "../templates/userPanel/index/UserNameField";
import UserPanelSidebarLinks from "../templates/userPanel/index/UserPanelSidebarLinks";
import { SidebarContext } from "@/app/context/ShowSidebarContext";

export default function SideBar() {
  const ShowSideBarContext = useContext(SidebarContext);
  return (
    <>
      {/* desktop */}
      <div className="hidden fixed lg:static inset-0 lg:inline-block w-[29%] bg-light dark:bg-dark-500 z-50">
        <div className="relative w-full h-full">
          <Image
            src="/images/sidebar-top.png"
            width={322}
            height={104}
            alt="عکس بک گراند پروفایل"
            className="w-full h-[152px]"
          />
          <div className="absolute top-[80px] right-[50%] translate-x-[50%] flex-center size-[108px] p-[5px] bg-light rounded-full overflow-hidden ">
            <Image
              src="/images/sidebar-profile.svg"
              width={108}
              height={108}
              alt="عکس پروفایل"
              className=" w-[98px] h-[98px]"
            />
          </div>
          <UserNameField />
          <div className="mt-8 w-[83%] h-px mx-auto bg-[#DDDEDF] dark:bg-[#DDDEDF]"></div>
        </div>
        <UserPanelSidebarLinks />
      </div>

      {/* mobile */}
      <div
        className={`${
          ShowSideBarContext?.isShowSidebar
            ? "translate-x-0 opacity-100"
            : "!translate-x-[100%] opacity-0"
        } lg:hidden fixed lg:static inset-0 w-screen  lg:w-[29%] h-screen lg:h-auto bg-neutral-800/60 backdrop-blur z-[100] transition-all duration-300`}
      >
        <div className="fixed lg:static inset-0 lg:inline-block w-[250px] md:w-[350px] lg:w-full bg-light dark:bg-dark-500 z-50">
          <div className="relative w-full h-full">
            <Image
              src="/images/sidebar-top.png"
              width={322}
              height={104}
              alt="عکس بک گراند پروفایل"
              className="w-full h-[152px]"
            />
            <div className="absolute top-[80px] right-[50%] translate-x-[50%] flex-center size-[108px] p-[5px] bg-light rounded-full overflow-hidden ">
              <Image
                src="/images/sidebar-profile.svg"
                width={108}
                height={108}
                alt="عکس پروفایل"
                className=" w-[98px] h-[98px]"
              />
            </div>
            <div className="absolute w-full">
              <UserNameField />
              <div className="mt-8 w-[83%] h-px mx-auto bg-[#DDDEDF] dark:bg-[#DDDEDF]"></div>
              <UserPanelSidebarLinks />
            </div>
          </div>
        </div>
        <div
          className="absolute inset-0 lg:hidden w-full h-full z-10"
          onClick={() => ShowSideBarContext?.setIsShowSidebar(false)}
        ></div>
      </div>
    </>
  );
}
