import { NotificationType } from "@/@types/notificaton";
import { getUserNotification } from "@/services/notification";
import { useQuery } from "@tanstack/react-query";
import Link from "next/link";
import React, { useState } from "react";

export default function NotificationBox() {
  const [isOpenNotificationModal, setIsOpenNotificationModal] =
    useState<boolean>(false);

  const { data: notification } = useQuery({
    queryKey: ["notification"],
    queryFn: getUserNotification,
    select: (res) => res.data,
  });

  const allNotificationNumber: number | null = notification
    ? Number(notification?.user.length) + Number(notification?.all.length)
    : null;

  const allNotificationData: NotificationType[] = notification
    ? [...notification?.user, ...notification?.all]
    : [];

  return (
    <div className="relative flex-center w-10 h-10 p-0.75 rounded-full ring-1 ring-[#DCFFF5] cursor-pointer">
      <div
        className="flex-center w-[34px] h-[34px] bg-secondary-default rounded-full overflow-hidden"
        onClick={() => setIsOpenNotificationModal((prv) => !prv)}
      >
        <svg className="size-5 text-light">
          <use href="#bell"></use>
        </svg>
        {allNotificationNumber && (
          <span className="absolute bottom-0 right-0 flex-center size-[18px] bg-red-500 text-xs pt-1  text-light rounded-full">
            {allNotificationNumber}
          </span>
        )}
      </div>
      {isOpenNotificationModal && (
        <ul
          className={`absolute top-12 -left-10 md:left-0 w-[300px] px-1 py-2 bg-[#F7F7FD] dark:bg-dark-500 border border-light-600/20 shadow-lg rounded-9 z-10 overflow-auto space-y-1 scrollbar-custom ${
            allNotificationData?.length > 0 ? "h-[175px]" : "h-[78px]"
          }`}
        >
          {allNotificationData?.length > 0 ? (
            allNotificationData?.map((item) => (
              <li
                key={item?._id}
                className="flex items-center justify-between gap-2 w-full p-1.5 bg-light dark:bg-dark-600 rounded-9"
              >
                <p className="text-sm line-clamp-1">{item?.title}</p>
                <Link
                  className="bg-secondary-default hover:bg-secondary-default/90 p-1 text-light text-xs rounded"
                  href={`/user-panel/notification`}
                >
                  مشاهده
                </Link>
              </li>
            ))
          ) : (
            <div className="flex-center w-full">
              <p className="py-1 text-xs text-light-600">اعلانی ندارید</p>
            </div>
          )}
          <div className="flex-center w-full">
            <Link
              className="p-1 mt-2 text-secondary-default text-xs rounded-10"
              href={`/user-panel/notification`}
            >
              مشاهده همه
            </Link>
          </div>
        </ul>
      )}
    </div>
  );
}
