"use client";
import Image from "next/image";
import React, { useState } from "react";

type UserType = {
  username: string;
  email: string;
  codemeli: string;
  fname: string;
  lname: string;
  gender: "مرد" | "زن";
  datebirth: string;
  avatar: string;
  _id: string;
};

export default function MultiselectBox({
  users,
  selectedUsers,
  setSelectedUsers,
}: {
  users: UserType[];
  selectedUsers: string[];
  setSelectedUsers: (value: string[]) => void;
}) {
  const [isShow, setIsShow] = useState<boolean>(
    selectedUsers.length > 0 ? true : false
  );

  const toggleUser = (id: string) => {
    if (selectedUsers.includes(id)) {
      setSelectedUsers(selectedUsers.filter((i) => i !== id));
    } else if (id === "all") {
      setSelectedUsers(["all"]);
    } else {
      setSelectedUsers([...selectedUsers, id]);
    }
  };

  return (
    <div className="w-full my-2">
      {/* Selected Tags */}
      <div
        className={`flex flex-wrap gap-2 w-full p-1.5 my-2 bg-neutral-500/20 dark:bg-dark-500 rounded-9 ${
          isShow ? "h-auto" : "h-12"
        }`}
      >
        {selectedUsers?.length > 0 ? (
          selectedUsers.map((id) => {
            const user = users.find((u) => u._id === id);
            const allUsers = id === "all";
            if (allUsers)
              return (
                <div
                  key={id}
                  className="flex items-center gap-1.5 py-2 bg-gray-100 dark:bg-secondary-default px-3 rounded-full"
                >
                  <svg className="size-5 rounded-full mr-3 text-success-400 dark:text-light">
                    <use href="#users"></use>
                  </svg>
                  <span className="text-sm">همه کاربران</span>

                  <button onClick={() => toggleUser(id)}>
                    <svg className="size-5 text-error-400 hover:text-red-600">
                      <use href="#x-mark"></use>
                    </svg>
                  </button>
                </div>
              );
            if (!user) return null;
            return (
              <div
                key={id}
                className="flex items-center gap-1.5 bg-gray-100 dark:bg-secondary-default px-3 py-1 rounded-full"
              >
                <Image
                  src={"/images/sidebar-profile.svg"}
                  className="w-8 h-8 rounded-full"
                  alt={user?.username}
                  width={60}
                  height={60}
                />
                <span className="text-sm">{user.fname + " " + user.lname}</span>

                <button onClick={() => toggleUser(id)}>
                  <svg className="size-5 text-error-400 hover:text-red-600">
                    <use href="#x-mark"></use>
                  </svg>
                </button>
              </div>
            );
          })
        ) : (
          <div
            className="flex items-center justify-between w-full my-auto px-2 py-2 text-neutral-200/50 cursor-pointer"
            onClick={() => setIsShow((prev) => !prev)}
          >
            <p>انتخاب کنید ...</p>
            <svg className="size-3 -rotate-90">
              <use href="#chevron-left"></use>
            </svg>
          </div>
        )}
      </div>
      {isShow && (
        <div className="border p-2 rounded-lg max-h-40 overflow-y-auto bg-white dark:bg-dark-500">
          <div
            className={`flex items-center justify-between p-2 my-1 w-full rounded-md cursor-pointer ${
              selectedUsers.includes("all")
                ? ""
                : "hover:bg-gray-100 hover:dark:bg-secondary-default/50 dark:bg-dark-500"
            } ${
              selectedUsers.includes("all")
                ? "bg-blue-100 dark:bg-secondary-default"
                : ""
            }`}
            onClick={() => toggleUser("all")}
          >
            <div>
              <div className="flex items-center gap-1">
                <svg className="size-5 rounded-full mr-3 text-success-400 dark:text-light">
                  <use href="#users"></use>
                </svg>
                <p className="text-sm font-medium ">همه کاربران</p>
              </div>
              <p className="mt-1 mr-3 text-sm text-gray-500 dark:text-light">
                All
              </p>
            </div>

            <div>
              {selectedUsers.includes("all") ? (
                <svg className="size-5 text-success-400 dark:text-light">
                  <use href="#check-circle"></use>
                </svg>
              ) : (
                ""
              )}
            </div>
          </div>
          {users.map((user) => (
            <div
              key={user._id}
              className={`flex items-center justify-between p-2 my-1 w-full rounded-md  ${
                selectedUsers.includes(user._id)
                  ? ""
                  : "hover:bg-gray-100 hover:dark:bg-secondary-default/50 dark:bg-dark-500"
              } ${
                selectedUsers.includes(user._id)
                  ? "bg-blue-100 dark:bg-secondary-default"
                  : ""
              }
              ${
                selectedUsers.includes("all")
                  ? " cursor-default"
                  : "cursor-pointer"
              }
              `}
              onClick={() => {
                if (!selectedUsers.includes("all")) {
                  toggleUser(user._id);
                }
              }}
            >
              <div>
                <div className="flex items-center gap-1">
                  <Image
                    src={"/images/sidebar-profile.svg"}
                    className="w-8 h-8 rounded-full mr-3"
                    alt={user?.username}
                    width={60}
                    height={60}
                  />

                  <p className="text-sm font-medium ">
                    {user.fname + " " + user.lname}
                  </p>
                </div>
                <p className="mt-1 mr-3 text-sm text-gray-500 dark:text-light">
                  {user.username}@
                </p>
              </div>

              <div>
                {selectedUsers.includes(user._id) ? (
                  <svg className="size-5 text-success-400 dark:text-light">
                    <use href="#check-circle"></use>
                  </svg>
                ) : (
                  ""
                )}
              </div>
            </div>
          ))}
        </div>
      )}
    </div>
  );
}
