"use client";
import React, { useContext, useState } from "react";

import SettlementBox from "@/components/modules/SettlementBox";
import { Button } from "@/components/ui/button";
import BankInfoCard from "@/components/modules/BankInfoCard";
import { useQuery } from "@tanstack/react-query";
import AddBankCardModal from "./AddBankCardModal";
import { getBank } from "@/services/bank";
import { bankDataType } from "@/@types/Bank";
import BankAccountDetailsModal from "./BankAccountDetailsModal";
import CustomToast from "@/components/modules/CustomToast";
import LoadingBox from "@/components/modules/LoadingBox";
import WithdrawRequestModal from "./WithdrawRequestModal";
import WithdrawalTable from "../orders/WithdrawalTable";
import { userContext } from "@/app/context/UserProvider";

export default function SettlementSection() {
  const [isOpenWithdrawRequestModal, setIsOpenWithdrawRequestModal] =
    useState<boolean>(false);
  const [isOpenMOdal, setIsOpenModal] = useState<boolean>(false);
  const [isOpenBankDetailsMOdal, setIsOpenBankDetailsMOdal] =
    useState<boolean>(false);
  const [bankId, setBankId] = useState<string>("");

  const user = useContext(userContext);

  const { data: banks, isLoading } = useQuery({
    queryKey: ["get-bankCard"],
    queryFn: getBank,
    select: (res) => res?.data,
  });

  const addCardHandler = () => {
    if (banks?.data?.bank.length === 2) {
      return CustomToast({
        type: "error",
        text: "حداکثر می‌ توانید 2 کارت بانکی را ثبت کنید",
      });
    }
    setIsOpenModal(true);
  };

  const filterBankAccount = (): bankDataType => {
    const data = banks.data.bank.filter(
      (bank: bankDataType) => bank._id === bankId
    );
    return data[0];
  };

  if (isLoading) return <LoadingBox />;
  return (
    <section className="w-full">
      <div className="w-full mt-3">
        <div className="flex flex-wrap items-center gap-2.25">
          <SettlementBox
            isBtn={true}
            setIsOpen={setIsOpenWithdrawRequestModal}
            value={user?.userInfo?.wallet ?? 0}
          />
          {/* <SettlementBox isBtn={false} />
          <SettlementBox isBtn={false} />
          <SettlementBox isBtn={false} /> */}
        </div>
      </div>
      <div className="w-full mt-[39px] py-[18px] px-[17px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div className="flex flex-wrap items-center justify-between gap-2.5 pb-[22px] border-b border-[#EDEDED] dark:border-neutral-500/50">
          <div>
            <p className="text-lg text-[#1D1D1D] dark:text-light">
              کارت های بانکی من
            </p>
            <div className="flex items-center gap-1 mt-1 child:text-neutral-500 dark:child:text-light/80">
              <svg className="size-4">
                <use href="#danger"></use>
              </svg>
              <p>
                توجه : شما میتوانید حداکثر 2 کارت بانکی (ایران و روسیه) ثبت
                نمایید
              </p>
            </div>
          </div>
          <div className="w-full md:w-auto">
            <Button
              className="flex items-center gap-3 w-[171px] h-10 px-5 mx-auto bg-secondary-default hover:bg-secondary-default/90 text-base-mines text-light rounded"
              onClick={addCardHandler}
            >
              <svg className="size-5 text-light">
                <use href="#plus"></use>
              </svg>
              افزودن کارت بانکی
            </Button>
          </div>
        </div>
        {banks?.data && (
          <div className="flex flex-wrap items-center justify-center lg:justify-start gap-[18px] mt-6">
            {banks.data.bank.map((bank: bankDataType) => (
              <BankInfoCard
                key={bank._id}
                id={bank._id}
                bank={bank.bankName}
                icon={bank.bankName}
                number={bank.cardNumber}
                status={bank.status}
                setIsOpenBankDetailsMOdal={setIsOpenBankDetailsMOdal}
                setBankId={setBankId}
              />
            ))}
          </div>
        )}
        {isOpenMOdal && <AddBankCardModal setIsOpenModal={setIsOpenModal} />}
        {isOpenBankDetailsMOdal && (
          <BankAccountDetailsModal
            setIsOpenModal={setIsOpenBankDetailsMOdal}
            filterBankAccount={filterBankAccount}
          />
        )}
      </div>
      {isOpenWithdrawRequestModal && (
        <WithdrawRequestModal
          setIsOpenWithdrawRequestModal={setIsOpenWithdrawRequestModal}
          banks={banks.data.bank}
        />
      )}
      <div className="w-full mt-[39px] py-[18px] px-[17px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md overflow-auto">
        <p className="text-lg text-[#1D1D1D] dark:text-light">
          درخواست‌های ثبت شده
        </p>
        <WithdrawalTable />
      </div>
    </section>
  );
}
