import CustomToast from "@/components/modules/CustomToast";
import React, { useContext } from "react";
import TransactionTable from "./TransactionTable";
import { userContext } from "@/app/context/UserProvider";

export default function ReferralSection() {
  const userData = useContext(userContext);

  const handleCopy = (text: string | number) => {
    navigator.clipboard.writeText(String(text)).then(() => {
      CustomToast({ type: "success", text: "کپی شد" });
    });
  };
  return (
    <>
      <section className="py-4 px-[23px] mt-3 bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <p className="font-bold text-[#1D1D1D]/80 dark:text-light text-lg">
          دوستان خود را به دارکوبیت دعوت کنید و سود کنید
        </p>
        <p className="mt-2 text-neutral-500 text-base-mines">
          کد دعوت خود را از قسمت زیر کپی کرده و برای دوستانتان ارسال کنید. در
          صورت ثبت نام دوست شما با کد (یا لینک) دعوت، درصدی از کل خرید او به شما
          تعلق خواهد گرفت .
        </p>
        <div className="flex flex-wrap items-center gap-3 mt-[50px] ">
          <div>
            <p className="font-medium text-[#696464] dark:text-light text-base-mines">
              تعداد دعوت های شما
            </p>
            {userData?.isLoading ? (
              <div className="flex items-center justify-end w-[164px] h-11 px-[18px] py-2.25 mt-2.25 text-left gap-10 bg-muted border border-[#EFEFEF] dark:border-[#4E4E4E]"></div>
            ) : (
              <div className="flex items-center justify-end w-[164px] px-[18px] py-2.25 mt-2.25 text-left gap-10 border border-[#EFEFEF] dark:border-[#4E4E4E]">
                <span className="text-[#515151] dark:text-light/85 text-xl font-medium">
                  {userData && userData?.userInfo?.invitation}
                </span>
                <span className="text-[#858282] dark:text-light/85 text-xl font-medium">
                  نفر
                </span>
              </div>
            )}
          </div>
          <div>
            <p className="font-medium text-[#696464] dark:text-light/85 text-base-mines">
              لینک دعوت شما
            </p>
            {userData?.isLoading ? (
              <div className="flex items-center justify-end  w-[370px] h-11 px-[18px] py-2.25 mt-2.25 text-left gap-10 border bg-muted border-[#EFEFEF] dark:border-[#4E4E4E] cursor-pointer animate-pulse"></div>
            ) : (
              <div
                className="flex items-center justify-end w-full px-[18px] py-2.25 mt-2.25 text-left gap-10 border border-[#EFEFEF] dark:border-[#4E4E4E] cursor-pointer"
                onClick={() =>
                  handleCopy(
                    `https://darkoobit.com?refCode=${
                      userData?.userInfo?.refcode ?? ""
                    }`
                  )
                }
              >
                <span className="text-[#515151] dark:text-light/85 text-base-mines font-medium">
                  {`https://darkoobit.com?refCode=${
                    userData?.userInfo?.refcode ?? ""
                  }`}
                </span>
                <svg className="size-6 text-secondary-default shrink-0">
                  <use href="#copy"></use>
                </svg>
              </div>
            )}
          </div>
          <div>
            <p className="font-medium text-[#696464] dark:text-light/85 text-base-mines">
              کد دعوت شما
            </p>
            {userData?.isLoading ? (
              <div
                className="flex items-center justify-end w-[160px] h-11 px-[18px] py-2.25 mt-2.25 text-left gap-10 bg-muted border border-[#EFEFEF] dark:border-[#4E4E4E] cursor-pointer"
                onClick={() => handleCopy(userData?.userInfo?.refcode ?? "")}
              ></div>
            ) : (
              <div
                className="flex items-center justify-end w-full px-[18px] py-2.25 mt-2.25 text-left gap-10 border border-[#EFEFEF] dark:border-[#4E4E4E] cursor-pointer"
                onClick={() => handleCopy(userData?.userInfo?.refcode ?? "")}
              >
                <span className="text-[#515151] dark:text-light/85 text-base-mines font-medium">
                  {userData && userData?.userInfo?.refcode}
                </span>
                <svg className="size-6 text-secondary-default shrink-0">
                  <use href="#copy"></use>
                </svg>
              </div>
            )}
          </div>
        </div>
      </section>
      <section className="px-2 md:px-[23px] py-[21px] mt-[25px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            تراکنش‌ها
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[10%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[90%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="w-full overflow-x-auto scrollbar-custom">
          <TransactionTable />
        </div>
      </section>
    </>
  );
}
