import { bankDataType } from "@/@types/Bank";
import { Button } from "@/components/ui/button";
import { BankNameFaHandler, getStatusLabel } from "@/lib/utils";
import Image from "next/image";
import React from "react";
type input = {
  id: number;
  label: string;
  required: boolean;
  inputType: string;
  value: "accountHolder" | "shaba" | "cardNumber";
  textarea?: boolean;
  ltr?: boolean;
  leftDir?: boolean;
};
type AddBankCardModalProps = {
  setIsOpenModal: React.Dispatch<React.SetStateAction<boolean>>;
  filterBankAccount: () => bankDataType;
};
export default function BankAccountDetailsModal({
  setIsOpenModal,
  filterBankAccount,
}: AddBankCardModalProps) {
  const inputs: input[] = [
    {
      id: 1,
      label: " نام و نام خانوادگی :",
      required: false,
      inputType: "text",
      value: "accountHolder",
    },
    {
      id: 2,
      label: "  شماره شبا :",
      required: false,
      inputType: "text",
      value: "shaba",
      leftDir: true,
    },
    {
      id: 3,
      label: " شماره کارت :",
      required: false,
      inputType: "text",
      value: "cardNumber",
      ltr: true,
    },
  ];
  const bankData = filterBankAccount();
  const bankFn = BankNameFaHandler(bankData.bankName);
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn">
      <div className="w-[350px] md:w-[600px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <div className="flex items-center justify-between">
            <div className="flex items-center gap-1.5">
              <p className="font-bold text-base text-[#001A46] dark:text-light">
                جزئیات حساب بانکی
              </p>
              {bankData.status === "approved" && (
                <span className="p-1.5 bg-[#00B074]/10 text-xs-mines text-[#00B074] rounded-sm">
                  {getStatusLabel(bankData.status)}
                </span>
              )}
              {bankData.status === "pending" && (
                <span className="p-1.5 bg-[#FF9D00]/10 text-xs-mines text-[#FF9D00] rounded-sm">
                  {getStatusLabel(bankData.status)}
                </span>
              )}
              {bankData.status === "rejected" && (
                <span className="p-1.5 bg-[#FF0000]/10 text-xs-mines text-[#FF0000] rounded-sm">
                  {getStatusLabel(bankData.status)}
                </span>
              )}
            </div>
            <span
              className="inline-flex items-center justify-center size-7 rounded-sm bg-error-400 hover:bg-error-400/90 text-light duration-150 cursor-pointer"
              onClick={() => setIsOpenModal(false)}
            >
              X
            </span>
          </div>
          <div className="flex items-center mt-4">
            <span className="w-[20%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[80%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <form className="w-full">
          <div className="grid  grid-cols-1 xl:grid-cols-2 gap-x-5 gap-y-7  mt-10">
            {inputs.map((input) => (
              <div
                key={input.id}
                className={"child:text-[#696464] dark:child:text-light"}
              >
                <p className="font text-lg">{input.label}</p>

                <input
                  className={`w-full h-[53px] mt-2.25 bg-[#EFEFEF] dark:bg-dark-500 p-4 text-base-mines rounded-sm ${
                    input.ltr ? "input__ltr" : ""
                  } ${input.leftDir ? "input__left" : ""}`}
                  type="text"
                  disabled
                  value={bankData[input.value]}
                />
              </div>
            ))}
            <div className={"child:text-[#696464] dark:child:text-light"}>
              <p className="font text-lg">نام بانک :</p>
              <div className="flex items-center gap-1.5 w-full h-[53px] mt-2.25 bg-[#EFEFEF] dark:bg-dark-500 p-4 text-base-mines rounded-sm">
                <Image
                  src={`/images/banks/${bankData.bankName}.svg`}
                  width={40}
                  height={40}
                  alt={bankFn}
                  className="w-5 h-5"
                />

                <p className="text-base">{bankFn}</p>
              </div>
            </div>
          </div>
          <div className="flex items-center justify-center gap-2.5 w-full mt-[32px]">
            <Button
              className="inline-block flex-center w-1/4 h-[53px] px-5  bg-secondary-default hover:bg-secondary-default/90 text-base dark:text-light rounded"
              type="submit"
              //   disabled={isPending}
              onClick={() => {
                setIsOpenModal(false);
              }}
            >
              تأیید
            </Button>
            <Button
              className="inline-block flex-center w-1/4 h-[53px] px-5  bg-error-300 hover:bg-error-300/90 text-base text-light rounded"
              type="submit"
              //   disabled={isPending}
              //   onClick={() => {
              //     !selectValue && setBankError(true);
              //   }}
            >
              حذف
            </Button>
          </div>
        </form>
      </div>

      <div
        className="absolute  w-full h-full z-40"
        onClick={() => {
          setIsOpenModal(false);
        }}
      ></div>
    </div>
  );
}
