"use client";
import { WithdrawalType } from "@/@types/withdrawal";
import { getWithdrawal } from "@/services/withdrawal";
import { useQuery } from "@tanstack/react-query";
import React from "react";

export default function WithdrawalTable() {
  const { data: withdrawals } = useQuery({
    queryKey: ["user-withdrawal"],
    queryFn: getWithdrawal,
    select: (res) => res.data,
  });
  return (
    <table className="w-full mt-7">
      <thead>
        <tr className="child:text-center child:text-[#A5A5A5] child:text-sm">
          <th>ردیف</th>
          <th> بانک</th>
          <th>تاریخ</th>
          <th>مبلغ</th>
          <th>وضعیت</th>
        </tr>
      </thead>
      {withdrawals && withdrawals?.data?.length > 0 ? (
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {withdrawals?.data.map(
            (withdrawal: WithdrawalType, index: number) => (
              <tr
                key={withdrawal._id}
                className=" child:py-[30px] child:px-2 child:text-right child:grow child:min-w-[200px] lg:child:w-[20%]"
              >
                <td>
                  <p className="text-[#575757] dark:text-light/80 text-sm text-center">
                    {index + 1}
                  </p>
                </td>
                <td>
                  <p className="text-[#575757] dark:text-light/80 text-sm text-center">
                    {withdrawal?.bankid}
                  </p>
                </td>
                <td>
                  <p className="text-[#575757] dark:text-light/80 text-base text-center">
                    {new Date(withdrawal?.updatedAt).toLocaleDateString(
                      "fa-IR"
                    )}
                  </p>
                </td>
                <td>
                  <p className="text-[#575757] dark:text-light/80 text-sm text-center">
                    {withdrawal?.amount?.toLocaleString()}
                  </p>
                </td>
                <td>
                  <p
                    className={`${
                      withdrawal?.status ? "text-[#00B074]" : "text-[#FF0000]"
                    } text-center text-base`}
                  >
                    {withdrawal?.status ? "تایید شده" : "لغو شده/ در حال برسی"}
                  </p>
                </td>
              </tr>
            )
          )}
        </tbody>
      ) : (
        <tbody>
          <tr>
            <td colSpan={4} className="text-center py-10 text-[#EE404C]">
              دیتایی یافت نشد
            </td>
          </tr>
        </tbody>
      )}
    </table>
  );
}
