"use client";
import React, { useState } from "react";
import SettlementSection from "../sales/SettlementSection";
import OrderComponent from "./OrderComponent";

export default function OrderContainer() {
  const [step, setStep] = useState<number>(1);

  return (
    <>
      <section className="flex items-center justify-start gap-1 w-full mt-9">
        <div
          className={`${
            step === 1
              ? "bg-secondary-default text-light"
              : "hover:bg-secondary-default text-[#A5A5A5] hover:text-light duration-150"
          } px-[25px] py-2.5 text-base-mines rounded-md cursor-pointer`}
          onClick={() => setStep(1)}
        >
          لیست سفارشات
        </div>
        <div
          className={`${
            step === 2
              ? "bg-secondary-default text-light"
              : "hover:bg-secondary-default text-[#A5A5A5] hover:text-light duration-150"
          } px-[25px] py-2.5 text-base-mines rounded-md cursor-pointer`}
          onClick={() => setStep(2)}
        >
          تسویه حساب
        </div>
      </section>
      {step === 1 && <OrderComponent />}
      {step === 2 && <SettlementSection />}
    </>
  );
}
