"use client";
import React, { useEffect, useState } from "react";
import OrdersTable from "./OrdersTable";
import { Button } from "@/components/ui/button";
import { useQuery } from "@tanstack/react-query";
import { getUserOrders } from "@/services/order";
import { orderType } from "@/@types/order";

export default function OrderComponent() {
  const [orderData, setOrderData] = useState<orderType[] | null>(null);
  const [searchText, setSearchText] = useState<string>("");

  const { data: orders, isLoading } = useQuery({
    queryKey: ["orders"],
    queryFn: getUserOrders,
    select: (res) => res.data,
  });
  useEffect(() => {
    if (orders) {
      setOrderData(orders?.data);
    }
  }, [orders]);

  const filteredOrders = () => {
    if (!searchText) {
      setOrderData(orders?.data);
    } else {
      const filterData = orderData?.filter((item: orderType) =>
        String(item?.uid).includes(searchText)
      );
      setOrderData(filterData && filterData?.length > 0 ? filterData : null);
    }
  };

  return (
    <>
      <section className="flex items-center justify-start w-full mt-7.25">
        <div className="flex w-full lg:w-[500px] xl:w-[625px] h-[54px] lg:h-16 bg-light dark:bg-dark-500 overflow-hidden rounded-md border border-light-450 dark:border-neutral-500/40">
          <input
            className="w-full h-full pr-[15px] lg:pr-[29px] bg-inherit text-[#919191] outline-none"
            type="text"
            placeholder="جستو جو کنید ...."
            value={searchText}
            onChange={(e) => setSearchText(e.target.value)}
          />
          <Button
            className="ml-2.5 my-2 size-[38px] lg:size-[47px] dark:bg-dark dark:hover:bg-dark/60 rounded-15 shrink-0"
            onClick={filteredOrders}
          >
            <svg className="size-[13px]">
              <use href="#magnifying"></use>
            </svg>
          </Button>
        </div>
      </section>
      <section className="w-full mt-3 py-5 px-2 md:px-[35px] bg-light dark:bg-[#393939] border border-[#EBEBEB] dark:border-neutral-500/50 rounded-md">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            لیست سفارشات
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[8%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[92%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="w-full overflow-x-auto scrollbar-custom">
          <OrdersTable isLoading={isLoading} orders={orderData} />
        </div>
      </section>
    </>
  );
}
