"use client";
import { SidebarContext } from "@/app/context/ShowSidebarContext";
import { userContext } from "@/app/context/UserProvider";
import Link from "next/link";
import { usePathname } from "next/navigation";
import React, { useContext } from "react";

export default function UserPanelSidebarLinks() {
  const pathname = usePathname();
  const pathnameSplit = pathname?.split("/");
  const pageUrl = pathnameSplit[2] ? pathnameSplit[2] : "/";
  const showSidebarContext = useContext(SidebarContext);

  const closeSidebarHandler = () => {
    showSidebarContext?.setIsShowSidebar(false);
  };

  const user = useContext(userContext);

  return (
    <ul className="h-[400px] md:h-auto px-[26px] my-6 space-y-2.25 overflow-y-auto">
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "/home"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/"
        >
          <svg className="size-5 shrink-0">
            <use href="#home"></use>
          </svg>
          <p>صفحه اصلی</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "/"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel"
        >
          <svg className="size-5 shrink-0">
            <use href="#squares-2x2"></use>
          </svg>
          <p>داشبورد</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "downloads"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/downloads"
        >
          <svg className="size-5 shrink-0">
            <use href="#shopping-cart"></use>
          </svg>
          <p>دانلود ها</p>
        </Link>
      </li>

      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "sales"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/sales"
        >
          <svg className="size-5 shrink-0">
            <use href="#doc"></use>
          </svg>
          <p>همکاری در فروش</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "wishlist"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/wishlist"
        >
          <svg className="size-5 shrink-0">
            <use href="#bookMark"></use>
          </svg>
          <p>علاقه مندی</p>
        </Link>
      </li>
      {/* <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "customers"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="#bookMark"
        >
          <svg className="size-5 shrink-0">
            <use href="#user"></use>
          </svg>
          <p>باشگاه مشتریان</p>
        </Link>
      </li> */}
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "orders"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/orders"
        >
          <svg className="size-5 shrink-0">
            <use href="#question"></use>
          </svg>
          <p>مالی</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "tickets"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/tickets"
        >
          <svg className="size-5 shrink-0">
            <use href="#chat-bubble-left-ellipsis"></use>
          </svg>
          <p>پشتیبانی</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "notification"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/notification"
        >
          <svg className="size-5 shrink-0">
            <use href="#bell-outline"></use>
          </svg>
          <p>اعلانات من</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "setting"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/setting"
        >
          <svg className="size-5 shrink-0">
            <use href="#arrows-right-left"></use>
          </svg>
          <p>تنظیمات</p>
        </Link>
      </li>
      <li
        className={`user-panel__sidebar-li group  ${
          pageUrl === "developers"
            ? "bg-secondary-default child:text-light"
            : "hover:bg-secondary-default dark:child:text-light"
        }`}
        onClick={closeSidebarHandler}
      >
        <Link
          className="user-panel__sidebar-link group-hover:text-light"
          href="/user-panel/developers"
        >
          <svg className="size-5 shrink-0">
            <use href="#world"></use>
          </svg>
          <p>فروشنده شوید</p>
        </Link>
      </li>
      {user?.userInfo?.isdev && (
        <li
          className={`user-panel__sidebar-li group  ${
            pageUrl === "files"
              ? "bg-secondary-default child:text-light"
              : "hover:bg-secondary-default dark:child:text-light"
          }`}
          onClick={closeSidebarHandler}
        >
          <Link
            className="user-panel__sidebar-link group-hover:text-light"
            href="/user-panel/files"
          >
            <svg className="size-5 shrink-0">
              <use href="#folder"></use>
            </svg>
            <p>فایل های من</p>
          </Link>
        </li>
      )}
      {user?.userInfo?.role === "SEO" && (
        <li
          className={`user-panel__sidebar-li group  ${
            pageUrl === "blogs"
              ? "bg-secondary-default child:text-light"
              : "hover:bg-secondary-default dark:child:text-light"
          }`}
          onClick={closeSidebarHandler}
        >
          <Link
            className="user-panel__sidebar-link group-hover:text-light"
            href="/user-panel/blogs"
          >
            <svg className="size-5 shrink-0">
              <use href="#document-text"></use>
            </svg>
            <p>مقاله های من</p>
          </Link>
        </li>
      )}
    </ul>
  );
}
