import { DownloadType } from "@/@types/download";
import CustomToast from "@/components/modules/CustomToast";
import { Button } from "@/components/ui/button";
import React, { Dispatch, SetStateAction } from "react";
type DownloadDetailsModalProps = {
  isOpen: boolean;
  setIsOpen: Dispatch<SetStateAction<boolean>>;
  data: DownloadType | null;
};
export default function DownloadDetailsModal({
  setIsOpen,
  data,
}: DownloadDetailsModalProps) {
  const clickHandler = (fileUrl: string, productName: string) => {
    if (fileUrl && fileUrl.length > 0) {
      const urls: string[] = JSON.parse(fileUrl);
      const link = document.createElement("a");
      link.href = urls[0];
      link.download = `${productName || "darkoobit"}_file`;
      document.body.appendChild(link);
      link.click();
      document.body.removeChild(link);
    } else {
      CustomToast({
        text: "فایلی برای دانلود یافت نشد",
        des: "لطفا برای دانلود فایل با پشتیبانی تماس بگیرد",
        type: "error",
      });
    }
  };

  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-50">
      <div className="w-[350px] md:w-[500px] p-3 bg-light dark:bg-dark-400 rounded-10 z-50">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            دانلود فایل
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[25%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[75%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <div className="divide-y divide-gray-200">
          {data?.products?.map((item) => (
            <div
              className="flex items-center justify-between w-full px-2 py-3"
              key={item?._id}
            >
              <p>{item?.productID?.title}</p>
              <Button
                className="flex-center w-[80px] h-[48px] px-5  bg-secondary-default hover:bg-secondary-default/90 text-base dark:text-light rounded"
                onClick={() =>
                  clickHandler(
                    item?.productID?.filePaths,
                    item?.productID?.title
                  )
                }
              >
                دانلود
              </Button>
            </div>
          ))}
        </div>
        <div className="flex-center gap-2.5 w-full py-2">
          <Button
            className="inline-block flex-center h-10 px-5 bg-red-600 hover:bg-red-500 text-base text-light rounded"
            onClick={() => {
              setIsOpen(false);
            }}
          >
            بستن
          </Button>
        </div>
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpen(false);
        }}
      ></div>
    </div>
  );
}
