import { getUserFiles } from "@/services/file";
import { useQuery } from "@tanstack/react-query";
import React, { useState } from "react";

export default function FileComboBox() {
  const [selectText, setSelectText] = useState<string>("");
  const [isOpen, setIsOpen] = useState<boolean>(false);

  //   const selectHandler = (file: OptionType) => {
  //     if (opt.value === "-1") {
  //       setIsOpen(false);
  //       return;
  //     }
  //     setSelectValue(opt.value);
  //     setSelectText(opt.text);
  //     setIsOpen(false);
  //   };

  const { data: files } = useQuery({
    queryKey: ["get-file"],
    queryFn: getUserFiles,
    select: (res) => res.data,
  });
  return (
    <div className="child:text-[#696464] dark:child:text-light">
      <p className="font text-lg">نام محصول :</p>
      <div className="relative w-full h-[53px] mt-2.25 bg-[#EFEFEF] dark:bg-dark-500 text-base-mines rounded-sm outline-none">
        <div
          className="w-full h-full p-4 pl-10 cursor-pointer"
          onClick={() => setIsOpen((prev) => !prev)}
        >
          {selectText ? (
            <div className="flex items-center gap-x-2.5">
              {/* <Image
                src={`/images/banks/${selectValue}.svg`}
                width={40}
                height={40}
                alt={selectText}
                className="w-5 h-5"
              /> */}

              <p onClick={() => setSelectText("")}>{selectText}</p>
            </div>
          ) : (
            "انتخاب کنید"
          )}
        </div>
        <div
          className={`${
            isOpen
              ? "absolute top-[60px] right-0 w-full h-[210px] p-2.5 bg-[#EFEFEF] dark:bg-dark-500 overflow-auto scrollbar-custom shadow-md"
              : "hidden"
          } `}
          onMouseLeave={() => setIsOpen(false)}
        >
          {/* {selectOptions.map((opt) => ( */}
          {files ? (
            files.data.length > 0 ? (
              files.data.map((file: { file: { id: string } }) => (
                <div
                  key={file.file.id}
                  className="flex items-center gap-x-2.5 space-y-1.5 p-1 hover:bg-light dark:hover:bg-dark-200 cursor-pointer duration-150"
                  // onClick={() => selectHandler(file)}
                >
                  {/* {opt.value !== "-1" && (
                <Image
                  src={`/images/banks/${opt.value}.svg`}
                  width={40}
                  height={40}
                  alt={opt.text}
                  className="w-5 h-5"
                />
              )} */}
                  <p className="pb-1">اسم محصول {file.file.id}</p>
                </div>
              ))
            ) : (
              <div className="flex items-center gap-x-2.5 space-y-1.5 p-1 dark:hover:bg-dark-200 duration-150">
                <p className="pb-1">محصولی یافت نشد</p>
              </div>
            )
          ) : (
            <p className="flex items-center gap-x-2.5 space-y-1.5 p-1 hover:bg-light dark:hover:bg-dark-200 cursor-pointer duration-150">
              لطفا صبر کنید
            </p>
          )}
        </div>
      </div>

      {/* {bankError && !selectValue && (
        <div className="flex items-center gap-2.5 w-full mt-2.5 child:text-[#FF0000] text-xs">
          <svg className="size-5 shrink-0">
            <use href="#danger"></use>
          </svg>
          <p className="text-wrap whitespace-normal">
            محصول خود را انتخاب کنید
          </p>
        </div>
      )} */}
    </div>
  );
}
