"use client";
import { getDevInfo } from "@/services/dev";
import { useQuery } from "@tanstack/react-query";
import React from "react";
import DevInfoForm from "./DevInfoForm";
import DevInformation from "./DevInformation";
import LoadingBox from "@/components/modules/LoadingBox";

export default function DevMainBox() {
  const {
    data: devData,
    isLoading,
    status,
  } = useQuery({
    queryKey: ["devInfo"],
    queryFn: getDevInfo,
  });

  if (isLoading) return <LoadingBox />;

  return (
    <>
      {status === "error" ? (
        <div className="w-full mt-10 p-5 bg-error-300/20 text-error-400 text-center text-base rounded-9 border border-error-300/10">
          حساب توسعه‌دهنده وجود ندارد لطفا ابتدا مشخصات خود را ثبت کنید
        </div>
      ) : (
        <>
          {devData?.data?.dev?.decisionReason &&
            devData?.data?.dev?.status === "rejected" && (
              <div className="w-full mt-10 p-5 bg-error-300/20 text-error-400 text-center text-base rounded-9 border border-error-300/10">
                به دلیل &quot;{" "}
                <span className="font-bold">
                  {devData?.data?.dev?.decisionReason}
                </span>{" "}
                &quot; رد شد.
              </div>
            )}
          <DevInformation />
        </>
      )}
      {status === "error" && <DevInfoForm devData={devData?.data.dev} />}
    </>
  );
}
