import React from "react";
import ProductDateInfo from "./ProductDateInfo";
import ProductInfo from "./ProductInfo";
import BestProducts from "./BestProducts";
import { file } from "@/@types/file";

type userInfoType = {
  amazingProductCount: number;
  avgScore: string;
  productCount: number;
  totalSellCount: number;
  totalSellMoney: number;
  user: {
    date: string;
    username: string;
    phone: string;
  };
};

type ProductDetailsProps = {
  userInfo: userInfoType;
  bestProducts: file[];
};

export default function ProductDetails({
  userInfo,
  bestProducts,
}: ProductDetailsProps) {
  return (
    <div className="w-full lg:w-[24%]">
      <ProductDateInfo
        date={userInfo?.user?.date}
        productCount={userInfo?.productCount}
        score={userInfo?.avgScore}
        phone={userInfo?.user?.username}
      />
      <ProductInfo
        date={userInfo?.user?.date}
        totalSellMoney={userInfo?.totalSellMoney}
        totalSellCount={userInfo?.totalSellCount}
        amazingProductCount={userInfo?.amazingProductCount}
      />
      <BestProducts besProduct={bestProducts} />
    </div>
  );
}
