import { Button } from "@/components/ui/button";
import React from "react";

type ProductDateInfoProps = {
  date: string;
  productCount: number;
  score: string;
  phone: string;
};

export default function ProductDateInfo({
  date,
  productCount,
  score,
  phone,
}: ProductDateInfoProps) {
  const roundedScore = () => {
    const scoreNumbered = Number(score || 0);
    const scoreCeil = Math.ceil(scoreNumbered);
    return scoreCeil;
  };
  const generateStarsFill = () => {
    const scoreNumber = roundedScore();
    if (scoreNumber > 5) return [0, 0, 0, 0, 0];

    const star = new Array(scoreNumber).fill(0);
    return star;
  };
  const generateStarsEmpty = () => {
    const scoreNumber = roundedScore();
    if (scoreNumber > 5) return [];
    const star = new Array(5 - scoreNumber).fill(0);
    return star;
  };
  return (
    <div className="px-4 py-3.5 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center justify-between px-4 py-2 bg-[#F9F9F9] dark:bg-[#525252] rounded-sm border border-dashed border-[#E4E4E4] dark:border-[#6B6B6B]">
        <p className="text-base-mines text-[#5E5E5E] dark:text-light">
          تاریخ عضویت :
        </p>
        <p className="text-base-mines text-dark dark:text-light">
          {new Date(date)?.toLocaleDateString("fa-IR")}
        </p>
      </div>
      <div className="flex items-center justify-between px-4 py-2 mt-2.75 bg-[#F9F9F9] dark:bg-[#525252] rounded-sm border border-dashed border-[#E4E4E4] dark:border-[#6B6B6B]">
        <p className="text-base-mines text-[#5E5E5E] dark:text-light">
          تعدا محصولات :
        </p>
        <p className="text-base-mines text-dark dark:text-light">
          {productCount}
        </p>
      </div>
      <div className="flex items-center justify-between mt-2.75">
        <p className="text-[#8F8F8F] dark:text-[#CCCCCC]">
          امتیاز <span className="text-[#5F5F5F] dark:text-light">4.57</span> از
          <span className="text-[#5F5F5F] dark:text-light">28</span> رأی
        </p>
        <div>
          <p className="text-[#F8B926] font-peyda text-xl font-black text-center">
            {score}
          </p>
          <div className="flex items-center gap-1 mt-0.5">
            {generateStarsEmpty().map((item: number, index: number) => (
              <svg key={index + item} className="size-4 text-neutral-100">
                <use href="#star-blue"></use>
              </svg>
            ))}
            {generateStarsFill().map((item: number, index: number) => (
              <svg key={index + item} className="size-4 text-secondary-default">
                <use href="#star-blue"></use>
              </svg>
            ))}
          </div>
        </div>
      </div>
      <div className="flex items-center w-full my-3.75">
        <span className="w-[60%] h-1 rounded-lg bg-primary-200"></span>
        <span className="w-[40%] h-1 rounded-lg bg-secondary-default"></span>
      </div>
      <Button
        className="inline-block flex-center w-full h-[51px] px-5 bg-secondary-default hover:bg-secondary-default/90 text-base text-light hover:text-light rounded-10"
        variant="outline"
        onClick={() => {
          window.open(`tel:${phone}`);
        }}
      >
        ارتباط با فروشگاه
      </Button>
    </div>
  );
}
