"use client";

import React, { useRef } from "react";

import { Swiper, SwiperSlide } from "swiper/react";

import "swiper/css";
import "swiper/css/pagination";

import "./../../../styles/swiperStyles.css";

import { Pagination } from "swiper/modules";
import SwiperCore from "swiper";
import BestProductCard from "@/components/modules/BestProductCard";
import { file } from "@/@types/file";

type BestProductsProps = {
  besProduct: file[];
};

export default function BestProducts({ besProduct }: BestProductsProps) {
  const swiperRef = useRef<SwiperCore>();
  const handlePrev = () => swiperRef.current?.slidePrev();
  const handleNext = () => swiperRef.current?.slideNext();

  return (
    <div className="px-4 py-3.5 my-1.75 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-3.75">
        <div className="flex flex-col">
          <span className="inline-block w-1 h-3.5 rounded-full bg-secondary-default"></span>
          <span className="inline-block w-1 h-[23px] rounded-full bg-primary-200"></span>
        </div>
        <p className="dark:text-light font-peyda font-bold text-base-mines">
          برترین محصولات
        </p>
      </div>
      <Swiper
        onSwiper={(swiper) => (swiperRef.current = swiper)}
        slidesPerView={1}
        spaceBetween={13}
        breakpoints={{
          0: {
            slidesPerView: 1,
            spaceBetween: 5,
          },
        }}
        modules={[Pagination]}
        className="mySwiper rounded cursor-pointer mt-2"
      >
        {besProduct?.map((item: file) => (
          <SwiperSlide
            key={item?._id}
            className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]"
          >
            <BestProductCard data={item} />
          </SwiperSlide>
        ))}
        {/* <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]"> */}
        {/* <BestProductCard />
        </SwiperSlide>
        <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]">
          <BestProductCard />
        </SwiperSlide>
        <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]">
          <BestProductCard />
        </SwiperSlide>
        <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]">
          <BestProductCard />
        </SwiperSlide>
        <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]">
          <BestProductCard />
        </SwiperSlide>
        <SwiperSlide className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]">
          <BestProductCard />
        </SwiperSlide> */}
      </Swiper>
      <div className="mt-9">
        <div className="flex-center gap-2">
          <div className="cursor-pointer" onClick={handlePrev}>
            <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
              <svg className="absolute -top-0.75 -right-3 size-9 text-dark-200 dark:text-light rotate-180">
                <use href="#arrow-left"></use>
              </svg>
            </span>
          </div>
          <div className="cursor-pointer" onClick={handleNext}>
            <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
              <svg className="absolute -top-0.75 right-1 size-9 text-dark-200 dark:text-light">
                <use href="#arrow-left"></use>
              </svg>
            </span>
          </div>
        </div>
      </div>
    </div>
  );
}
