"use client";

import React, { useState } from "react";

import { Slider } from "@/components/ui/Slider";
// import FileTypeFilterAccordion from "../../category/categoryName/FileTypeFilterAccordion";
// import CategoryFilterAccordion from "../../category/categoryName/CategoryFilterAccordion";
import CheckboxItems from "../../category/categoryName/CheckboxItems";
import ShopAccordion from "../../category/categoryName/ShopAccordion";
// import SwitchItems from "../../category/categoryName/SwitchItems";

export default function ProductsSearchFilter() {
  const [range, setRange] = useState<number[]>([0, 100000000]);
  return (
    <div className="w-full lg:w-[24%] px-3.75 py-2.5 bg-light dark:bg-[#393939] rounded-15 border border-[#F2F2F2] dark:border-[#4E4E4E]">
      <div className="flex items-center justify-between pb-2 border-b border-dark/[7%] dark:border-light/10">
        <p className="text-sm text-[#A5A5A5]">فیلتر ها</p>
        <p className="text-secondary-default dark:text-light">حذف همه</p>
      </div>
      <div>
        <p className="py-3.5 text-dark dark:text-light text-sm font-medium">
          محدوده قیمت{" "}
        </p>
        <Slider
          value={range}
          onValueChange={setRange}
          max={100000000}
          step={100000}
          className="my-3"
        />
        <div className="flex justify-between my-2 pb-3.25 text-xs font-medium text-dark dark:text-[#BEBEBE]  border-b border-dark/[7%] dark:border-light/10">
          <span>{range[0].toLocaleString("fa-IR")} تومان</span>
          <span>{range[1].toLocaleString("fa-IR")} تومان</span>
        </div>
      </div>
      {/* <CategoryFilterAccordion /> */}
      {/* <FileTypeFilterAccordion /> */}
      <CheckboxItems />
      <ShopAccordion />
      {/* <SwitchItems /> */}
    </div>
  );
}
