"use client";
import React, { useRef } from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import "swiper/css";
import "swiper/css/pagination";

import "./../../../../styles/swiperStyles.css";

import { Pagination } from "swiper/modules";
import BestProductCard from "@/components/modules/BestProductCard";
import type { Swiper as SwiperType } from "swiper";
import { useQuery } from "@tanstack/react-query";
import { getProductByCategory } from "@/services/produts";
import { file } from "@/@types/file";

export default function SimilarProducts({ id }: { id: string }) {
  const { data } = useQuery({
    queryKey: ["product-category"],
    queryFn: () => getProductByCategory(id),
    select: (res) => res.data.files,
  });

  const swiperRef = useRef<SwiperType>();
  const handlePrev = () => swiperRef.current?.slidePrev();
  const handleNext = () => swiperRef.current?.slideNext();

  return (
    <div className="mt-2.5 p-[18px] bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-3.75">
        <div className="flex flex-col">
          <span className="inline-block w-1 h-3.5 rounded-full bg-secondary-default"></span>
          <span className="inline-block w-1 h-[23px] rounded-full bg-primary-200"></span>
        </div>
        <p className="dark:text-light font-peyda font-bold text-xl">
          محصولات مشابه
        </p>
      </div>
      <div className="flex items-center gap-x-3.5">
        <div className="cursor-pointer" onClick={handlePrev}>
          <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
            <svg className="absolute -top-0.75 -right-3 size-9 text-dark-200 dark:text-light rotate-180">
              <use href="#arrow-left"></use>
            </svg>
          </span>
        </div>
        <Swiper
          onSwiper={(swiper) => (swiperRef.current = swiper)}
          slidesPerView={1}
          spaceBetween={5}
          breakpoints={{
            0: {
              slidesPerView: 1,
              spaceBetween: 5,
            },
          }}
          modules={[Pagination]}
          className="mySwiper rounded cursor-pointer !w-[370px]"
        >
          {data?.map((item: file) => (
            <SwiperSlide
              key={item._id}
              className="flex flex-col items-start justify-start !bg-light dark:!bg-dark-300 dark:child:text-light rounded-[26px]"
            >
              <BestProductCard data={item} />
            </SwiperSlide>
          ))}
        </Swiper>
        <div className="cursor-pointer" onClick={handleNext}>
          <span className="relative inline-block size-7 bg-[#ECEDF4] hover:bg-[#ECEDF4]/70 dark:bg-dark-500 hover:dark:bg-dark-500/70 rounded-full">
            <svg className="absolute -top-0.75 right-1 size-9 text-dark-200 dark:text-light">
              <use href="#arrow-left"></use>
            </svg>
          </span>
        </div>
      </div>
    </div>
  );
}
