import React from "react";
import DOMPurify from "dompurify";

export default function ProductSubDesc({ text }: { text: string }) {
  const cleanText = DOMPurify.sanitize(text, { USE_PROFILES: { html: true } });

  return (
    <div
      className="w-full lg:w-[400px] xl:w-[545px] mt-3.75 font-medium text-sm-mines sm:text-lg text-[#8D8D8D] dark:text-[#C9C9C9]"
      dangerouslySetInnerHTML={{ __html: cleanText }}
    ></div>
  );
}
