import React from "react";

export default function ProductInfoHeader() {
  return (
    <div className="flex items-center gap-2 md:gap-[52px] w-full px-2.25 md:px-[22px] py-4 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-1 md:gap-2.5">
        <svg className="size-[22px] text-secondary-default dark:text-light shrink-0">
          <use href="#information-circle"></use>
        </svg>
        <p className="font-medium text-xs md:text-base text-dark dark:text-light">
          توضیحات
        </p>
      </div>
      <div className="flex items-center gap-1 md:gap-2.5">
        <svg className="size-[22px] text-secondary-default dark:text-light shrink-0">
          <use href="#question"></use>
        </svg>
        <p className="font-medium text-xs md:text-base text-[#9F9F9F] dark:text-[#ACACAC]">
          پرسش و پاسخ
        </p>
      </div>
      <div className="flex items-center gap-1 md:gap-2.5">
        <svg className="size-[22px] text-secondary-default dark:text-light shrink-0">
          <use href="#message"></use>
        </svg>
        <p className="font-medium text-xs md:text-base text-[#9F9F9F] dark:text-[#ACACAC]">
          پشتیبانی
        </p>
      </div>
    </div>
  );
}
