import { file } from "@/@types/file";
import Breadcrumb from "@/components/modules/Breadcrumb";
import CustomToast from "@/components/modules/CustomToast";
import { Button } from "@/components/ui/button";
import Image from "next/image";
import React from "react";
import AddWish from "./AddWish";

type ProductHerosectionProps = {
  data: file;
  handleBuy: () => void;
};

export default function ProductHerosection({
  data,
  handleBuy,
}: ProductHerosectionProps) {
  const copyHandler = () => {
    if (!data?.uid) {
      return CustomToast({
        type: "error",
        text: "شناسه محصول موجود نیست",
      });
    }
    const domain = window.location.origin;
    const link = `${domain}/products/${encodeURIComponent(data?.title || "")}/${
      data.uid
    }`;
    navigator.clipboard
      .writeText(link)
      .then(() =>
        CustomToast({ type: "success", text: "لینک محصول با موفقیت کپی شد" })
      )
      .catch(() =>
        CustomToast({
          type: "error",
          text: "مرورگر شما از کپی لینک پشتیبانی نمی‌کند",
        })
      );
  };

  return (
    <section className="px-5 sm:px-[43px] pt-[27px] pb-[25px] sm:pb-[57px] mt-[43px] bg-light dark:bg-[#393939] shadow">
      <Breadcrumb
        items={[
          { value: "فروشگاه", href: "/products" },
          {
            value: data?.title,
            href: `/products/${data?.title}/${data?.uid}`,
          },
        ]}
      />
      <div className="flex flex-col lg:flex-row items-start justify-between gap-[25px] sm:gap-[55px]">
        <div>
          <h1 className="w-full lg:w-[400px] xl:w-[585px] pt-[28px] font-peyda font-bold text-xl sm:text-2xl md:text-4xl leading-8 md:leading-[60px]">
            {data?.title}
          </h1>
          <p className="w-full lg:w-[400px] xl:w-[545px] mt-3.75 font-medium text-sm-mines sm:text-lg text-[#8D8D8D] dark:text-[#C9C9C9]">
            {data?.subdecs}
          </p>
          <div className="hidden lg:inline-block relative mt-[41px] w-[430px] xl:w-[580px] h-[83px]">
            <svg className="w-full h-full dark:hidden">
              <use href="#product-details-bg"></use>
            </svg>
            <svg className="hidden dark:inline-block w-full h-full">
              <use href="#product-details-bg-dark"></use>
            </svg>

            <div className="absolute top-3.75 right-5 xl:right-[42px]">
              <p className="text-secondary-default dark:text-primary-200 font-peyda font-black text-xl xl:text-2xl-mines text-center">
                {data?.price?.toLocaleString()}
              </p>
              <p className="text-center text-[#8F8F8F] dark:text-[#BEBEBE] text-base">
                تومـــــــان
              </p>
            </div>
            <div className="absolute top-3.75 right-[170px] xl:right-[236px] flex justify-center">
              <div>
                <p className="text-[#3D3D3D] dark:text-light font-peyda font-black text-xl xl:text-2xl-mines text-center">
                  {data?.salesCount}
                </p>
                <p className="text-center text-[#8F8F8F] dark:text-[#BEBEBE] text-base">
                  فروش
                </p>
              </div>
              <svg className="size-8 mt-2 mr-[19px] text-[#8D8D8D] dark:text-[#C3C3C3]">
                <use href="#shop"></use>
              </svg>
            </div>
            <div className="absolute top-3.75 left-2.5 xl:left-5 flex justify-center">
              <div>
                <p className="text-[#FFA700] font-peyda font-black text-xl xl:text-2xl-mines text-center">
                  {data?.Score}
                </p>
                <p className="text-center text-[#8F8F8F] dark:text-[#DADADA] text-base">
                  از{" "}
                  <span className="text-[#626262] dark:text-[#BABABA] font-bold">
                    3456
                  </span>{" "}
                  رای
                </p>
              </div>
              <svg className="size-[28px] mt-2 mr-1 text-[#8D8D8D] dark:text-[#C3C3C3] shrink-0">
                <use href="#star-outline"></use>
              </svg>
            </div>
          </div>
          <div className="hidden lg:inline-flex items-center justify-between mt-6">
            <div className="flex items-center justify-between gap-2.5">
              {data?.previewlink !== "" && (
                <Button
                  className="h-[55px] w-[165px] bg-[#E6F0FF] hover:bg-secondary-default dark:bg-[#525252] dark:hover:bg-[#525252]/90 font-bold text-base text-secondary-default hover:text-light dark:text-light border border-[#B1D1FF] dark:border-[#4E4E4E] rounded-10"
                  variant="outline"
                  onClick={() => window.open(data?.previewlink, "_blank")}
                >
                  پیش نمایش
                </Button>
              )}
              <Button
                className="h-[55px]  bg-secondary-default dark:bg-primary-200 hover:bg-secondary-default/90  dark:hover:bg-primary-200/80 text-light hover:text-light dark:text-dark border border-[#B1D1FF] dark:border-primary-default rounded-10"
                variant="outline"
                onClick={handleBuy}
              >
                <span className="inline-block mr-[23px] text-base font-bold">
                  خرید
                </span>
                <svg className="dark:hidden !size-[28px] mr-8 ml-2.5  shrink-0">
                  <use href="#chevron-left-circle"></use>
                </svg>
                <svg className="hidden dark:inline-block !size-[28px] mr-8 ml-2.5  shrink-0">
                  <use href="#chevron-left-circle-dark"></use>
                </svg>
              </Button>
            </div>
            <div className="flex items-center gap-1.5 mr-2.5 child:bg-light dark:child:bg-[#525252] hover:child:bg-light-200 dark:hover:child:bg-[#525252]/80 child:duration-150 child:cursor-pointer">
              <AddWish fileId={data?._id} />
              <div
                className="p-2  border border-[#D9D9D9] dark:border-[#4E4E4E] rounded-sm"
                onClick={copyHandler}
              >
                <svg className="size-5 shrink-0">
                  <use href="#share"></use>
                </svg>
              </div>
            </div>
          </div>
        </div>
        {/* image */}
        <div className="relative w-[260px] sm:w-[350px] xl:w-[419px] h-[260px] sm:h-[350px] xl:h-[419px] mx-auto">
          <div className="w-[260px] sm:w-[350px] xl:w-[419px] h-[260px] sm:h-[350px] xl:h-[419px] shrink-0 overflow-hidden rounded-10">
            <Image
              src={
                data?.images
                  ? process.env.NEXT_PUBLIC_BASE_URL + data?.images[0]
                  : "/images/product1.png"
              }
              width={419}
              height={419}
              alt="عکس محصول"
              className="absolute w-full h-full shrink-0 rounded-10 z-20"
            />
          </div>
          <div className="absolute -top-[17px] sm:-top-[22px] -right-5 sm:-right-[27px] w-[261px] sm:w-[250px] xl:w-[358px] h-[250px] xl:h-[348px] bg-primary-default/20 dark:bg-light/[4%] rounded-10 z-10"></div>
          <div className="absolute -bottom-[19px] sm:-bottom-[25px] -left-[19px] sm:-left-[25px] w-[261px] sm:w-[250px] xl:w-[358px] h-[250px] xl:h-[348px] bg-secondary-default/10 dark:bg-light/[4%] rounded-10 z-10"></div>
        </div>
        <div className="inline-block lg:hidden relative w-[300px] h-[83px] mx-auto">
          <svg className="w-full h-full dark:hidden">
            <use href="#product-details-bg-mobile"></use>
          </svg>
          <svg className="hidden dark:inline-block w-full h-full">
            <use href="#product-details-bg-mobile-dark"></use>
          </svg>
          <div className="absolute top-3.75 right-5 xl:right-[42px]">
            <p className="text-secondary-default dark:text-[#FFE351] font-peyda font-black text-lg text-center">
              {data?.price?.toLocaleString()}
            </p>
            <p className="text-center text-[#8F8F8F] dark:text-[#8F8F8F] text-sm">
              تومـــــــان
            </p>
          </div>
          <div className="absolute top-3.75 right-[123px] flex justify-center">
            <div>
              <p className="text-[#3D3D3D] dark:text-light font-peyda font-black text-base text-center">
                2,865
              </p>
              <p className="text-center text-[#8F8F8F] dark:text-[#C3C3C3] text-base">
                فروش
              </p>
            </div>
            <svg className="size-[21px] mt-2 mr-1 text-[#8D8D8D] dark:text-[#C3C3C3]">
              <use href="#shop"></use>
            </svg>
          </div>
          <div className="absolute top-3.75 left-1  flex justify-center">
            <div>
              <p className="text-[#FFA700] font-peyda font-black text-base text-center">
                {data?.Score}
              </p>
              <p className="text-center text-[#8F8F8F] dark:text-[#8F8F8F] text-sm-mines">
                از{" "}
                <span className="text-[#626262] dark:text-[#626262] font-bold">
                  3456
                </span>{" "}
                رای
              </p>
            </div>
            <svg className="size-[19px] mt-2 text-[#8D8D8D] dark:text-[#8D8D8D] shrink-0">
              <use href="#star-outline"></use>
            </svg>
          </div>
        </div>
        <div className="inline-flex lg:hidden flex-col-reverse sm:flex-row items-center justify-between mx-auto mt-6">
          <div className="flex items-center justify-between gap-2.5">
            {data?.previewlink !== "" && (
              <Button
                className="h-[55px] w-[165px] bg-[#E6F0FF] hover:bg-secondary-default dark:bg-[#525252] dark:hover:bg-[#525252]/90 font-bold text-base text-secondary-default hover:text-light dark:text-light border border-[#B1D1FF] dark:border-[#4E4E4E] rounded-10"
                variant="outline"
                onClick={() => window.open(data?.previewlink, "_blank")}
              >
                پیش نمایش
              </Button>
            )}
            <Button
              className="h-[55px]  bg-secondary-default dark:bg-primary-200 hover:bg-secondary-default/90  dark:hover:bg-primary-200/80 text-light hover:text-light dark:text-dark border border-[#B1D1FF] dark:border-primary-default rounded-10"
              variant="outline"
              onClick={handleBuy}
            >
              <span className="inline-block mr-[23px] text-base font-bold">
                خرید
              </span>
              <svg className="dark:hidden !size-[28px] sm:mr-8 ml-2.5 shrink-0">
                <use href="#chevron-left-circle"></use>
              </svg>
              <svg className="hidden dark:inline-block !size-[28px] mr-8 ml-2.5  shrink-0">
                <use href="#chevron-left-circle-dark"></use>
              </svg>
            </Button>
          </div>
          <div className="flex items-center gap-1.5 w-full sm:mr-5 mb-[25px] sm:mb-0 child:bg-light dark:child:bg-[#525252] hover:child:bg-light-200 dark:hover:child:bg-[#525252]/80 child:duration-150 child:cursor-pointer">
            <div className="flex items-center  sm:justify-normal gap-1.5 p-2 border sm:border-none border-[#D9D9D9] dark:border-[#4E4E4E] rounded-sm">
              <span className="sm:hidden text-sm font-medium">
                افزودن به علاقه مندی
              </span>
              <AddWish fileId={data?._id} />
            </div>
            <div
              className="flex items-center  justify-between sm:justify-normal gap-1.5 p-2  border border-[#D9D9D9] dark:border-[#4E4E4E] rounded-xs"
              onClick={copyHandler}
            >
              <span className="sm:hidden text-sm font-medium">
                اشتراک گذاری
              </span>

              <svg className="size-5 shrink-0">
                <use href="#share"></use>
              </svg>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
