import { CommentsType } from "@/@types/comment";
import CommentBox from "@/components/modules/CommentBox";
import React from "react";

type ProductCommentsProps = {
  commentsData: CommentsType;
  onReply: (id: string) => void;
};

export default function ProductComments({
  commentsData,
  onReply,
}: ProductCommentsProps) {
  return (
    <section className="w-full px-9 py-[28px] mt-3.75 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-3.75 pb-5">
        <div className="flex flex-col">
          <span className="inline-block w-1 h-3.5 rounded-full bg-secondary-default"></span>
          <span className="inline-block w-1 h-[23px] rounded-full bg-primary-200"></span>
        </div>
        <p className="dark:text-light font-peyda font-bold text-xl">
          پرسش و پاسخ
        </p>
      </div>

      {commentsData ? (
        commentsData?.comments?.map((comment) => (
          <CommentBox key={comment._id} data={comment} onReply={onReply} />
        ))
      ) : (
        <div className="w-full">
          <svg className="w-[112px] h-[100px] mx-auto">
            <use href="#empty-comment-icon"></use>
          </svg>
          <p className="mt-2 text-center">نظری برای این مقاله ثبت نشده است</p>
        </div>
      )}
    </section>
  );
}
