import CommentForm from "@/components/modules/CommentForm";
import React from "react";

type CommentAnswerFormProps = {
  productId: string;
  keyValue: string[];
  textareaRef: React.RefObject<HTMLFormElement>;
  commentId: string;
};

export default function CommentAnswerForm({
  productId,
  keyValue,
  textareaRef,
  commentId,
}: CommentAnswerFormProps) {
  return (
    <section className="w-full px-9 py-[28px] mt-3.75 bg-light dark:bg-[#393939] border border-[#E4E4E4] dark:border-[#4E4E4E] rounded-lg">
      <div className="flex items-center gap-3.75 pb-5 border-b border-dark/10 dark:border-light/[15%]">
        <div className="flex flex-col">
          <span className="inline-block w-1 h-3.5 rounded-full bg-secondary-default"></span>
          <span className="inline-block w-1 h-[23px] rounded-full bg-primary-200"></span>
        </div>
        <p className="dark:text-light font-peyda font-bold text-xl">پشتیبانی</p>
      </div>
      <CommentForm
        productId={productId}
        keyValue={keyValue}
        textareaRef={textareaRef}
        commentId={commentId}
      />
    </section>
  );
}
