"use client";
import { ApiError, ApiResponse } from "@/@types/api";
import { userContext } from "@/app/context/UserProvider";
import CustomToast from "@/components/modules/CustomToast";
import { deleteWish, sendWish } from "@/services/wishlist";
import { useMutation } from "@tanstack/react-query";
import { AxiosResponse } from "axios";
import React, { useContext, useState } from "react";

export default function AddWish({ fileId }: { fileId: string }) {
  const userInfContext = useContext(userContext);
  const [isExist, setIsExist] = useState(false);
  const { mutate } = useMutation<
    AxiosResponse<ApiResponse<string>>,
    ApiError,
    { fileid: string }
  >({
    mutationFn: sendWish,
  });
  const { mutate: delete_mutate } = useMutation<
    AxiosResponse<ApiResponse<string>>,
    ApiError,
    string
  >({
    mutationFn: deleteWish,
  });
  const clickHandler = () => {
    if (!userInfContext?.userInfo) {
      return CustomToast({
        text: "لطفا ابتیدا وارد حساب کاربری خود شوید",
        type: "error",
      });
    }
    mutate(
      { fileid: fileId },
      {
        onSuccess: (res) => {
          if (res.status === 200) {
            CustomToast({
              type: "success",
              text: "محصول مورد نظر با موفقیت به علاقه‌مندی‌ها اضافه شد",
            });
            setIsExist(true);
          }
        },
        onError: (error) => {
          const statusCode = error?.response?.status;
          if (statusCode === 400) {
            CustomToast({
              type: "error",
              text: "ورودی نامعتبر — fileid ارسال نشده",
            });
          } else if (statusCode === 401) {
            CustomToast({
              type: "error",
              text: "محصول قبلا در علاقه مندی های شما اضافه شده است",
            });
          } else {
            CustomToast({
              type: "error",
              text: "خطا در انجام عملیات",
              des: "لطفا دوباره امتحان کنید",
            });
          }
        },
      }
    );
  };

  const removeHandler = () => {
    if (!userInfContext?.userInfo) {
      return CustomToast({
        text: "لطفا ابتیدا وارد حساب کاربری خود شوید",
        type: "error",
      });
    }
    delete_mutate(fileId, {
      onSuccess: (res) => {
        if (res.status === 200) {
          CustomToast({
            type: "success",
            text: "محصول مورد نظر با موفقیت از علاقه‌مندی‌ها حذف شد",
          });
          setIsExist(false);
        }
      },
      onError: (error) => {
        const statusCode = error?.response?.status;
        if (statusCode === 400) {
          CustomToast({
            type: "error",
            text: "	مورد پیدا نشد",
          });
        } else if (statusCode === 401) {
          CustomToast({
            type: "error",
            text: "عدم دسترسی — توکن ارسال نشده یا نامعتبر",
          });
        } else {
          CustomToast({
            type: "error",
            text: "خطا در انجام عملیات",
            des: "لطفا دوباره امتحان کنید",
          });
        }
      },
    });
  };
  return (
    <>
      {isExist ? (
        <div
          className={`p-2 border border-[#D9D9D9] dark:border-[#4E4E4E] rounded-sm !bg-red-600`}
          onClick={removeHandler}
        >
          <svg className={`size-5 shrink-0 text-light`}>
            <use href="#heart"></use>
          </svg>
        </div>
      ) : (
        <div
          className={`sm:p-2 sm:border border-[#D9D9D9] dark:border-[#4E4E4E] rounded-sm`}
          onClick={clickHandler}
        >
          <svg className={`size-5 shrink-0`}>
            <use href="#heart"></use>
          </svg>
        </div>
      )}
    </>
  );
}
