"use client";
import React, { Dispatch, SetStateAction } from "react";

import { paginationType } from "@/@types/pagination";
import PaginationContainer from "@/components/modules/PaginationContainer";
import ProductCard from "@/components/modules/ProductCard";
import NotFoundDataBox from "@/components/modules/NotFoundDataBox";
import { file } from "@/@types/file";

type ProductsGridProps = {
  products: file[];
  totalPage: number;
  paginationSize: paginationType;
  setPaginationSize: Dispatch<SetStateAction<paginationType>>;
};

export default function ProductsGrid({
  products,
  totalPage,
  paginationSize,
  setPaginationSize,
}: ProductsGridProps) {
  return (
    <div className="w-full lg:w-[76%]">
      {products?.length > 0 ? (
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-x-5 gap-y-3.75 my-3.5">
          {products?.map((file: file) => (
            <ProductCard key={file._id} data={file} />
          ))}
        </div>
      ) : (
        <NotFoundDataBox />
      )}
      {products?.length > 0 && (
        <div className="w-full">
          <PaginationContainer
            page={paginationSize.page}
            setPage={setPaginationSize}
            totalPages={totalPage}
          />
        </div>
      )}
    </div>
  );
}
