"use client";

import { ApiError, ApiResponse } from "@/@types/api";
import { file } from "@/@types/file";
import { OrderItemType } from "@/@types/order";
import { OrderCountContext } from "@/app/context/OrderCountProvider";
import LoadingBox from "@/components/modules/LoadingBox";
import OrderCard from "@/components/modules/OrderCard";
import { getUserBasketFils } from "@/services/order";
import { useMutation } from "@tanstack/react-query";
import { AxiosResponse } from "axios";
import Link from "next/link";
import React, { useContext, useEffect, useState } from "react";

export default function OrderBox() {
  const { mutate, isPending } = useMutation<
    AxiosResponse<ApiResponse<file[]>>,
    ApiError,
    { ids: string[] }
  >({
    mutationFn: getUserBasketFils,
  });
  const contextData = useContext(OrderCountContext);

  const [orders, setOrders] = useState<[] | file[]>([]);

  useEffect(() => {
    if (contextData?.orderCount === 0) return;
    const ids: string[] | undefined = contextData?.localDate.map(
      (item: OrderItemType) => item.productid
    );

    if (ids && ids?.length > 0) {
      mutate(
        {
          ids,
        },
        {
          onSuccess: (res) => {
            setOrders(res.data.data ?? []);
          },
        }
      );
    }
  }, [contextData]);

  if (isPending) return <LoadingBox />;

  return (
    <section className="w-full md:w-[67%] bg-light border border-[#F2F2F2] rounded-10">
      {orders.length > 0 ? (
        orders?.map((item: file) => <OrderCard key={item._id} data={item} />)
      ) : (
        <div className="p-5 text-center">
          <p className="font-bold">
            سبد خرید شما خالی است برای مشاهده لیست محصولات کلیک کنید
          </p>
          <Link
            className="inline-block my-2.5 bg-secondary-default text-white p-2.5 rounded-md"
            href="/products"
          >
            مشاهده محصولات
          </Link>
        </div>
      )}
    </section>
  );
}
