"use client";
import React, { useEffect, useState } from "react";
import OtpLogin from "./OtpLogin";
import PhoneLogin from "./PhoneLogin";
import Register from "../register/Register";
import LoginPassword from "./LoginPassword";

type AuthProps = {
  isLoginModal: boolean;
  setIsLoginModal: React.Dispatch<React.SetStateAction<boolean>>;
  refCode: null | string;
};
type user = {
  phone: string;
  username: string;
  email: string;
  password: string;
  fname: string;
  lname: string;
  refCode: string;
};
export default function Auth({
  isLoginModal,
  setIsLoginModal,
  refCode,
}: AuthProps) {
  const [step, setStep] = useState<number>(0);
  const [phone, setPhone] = useState<string>("");
  const [isRegister, setIsRegister] = useState<boolean>(false);
  const [userInfo, setUserInfo] = useState<user>({
    phone: "",
    username: "",
    email: "",
    password: "",
    fname: "",
    lname: "",
    refCode: "",
  });

  useEffect(() => {
    if (isLoginModal) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "";
    }
    return () => {
      document.body.style.overflow = "";
    };
  }, [isLoginModal]);
  useEffect(() => {
    if (refCode) {
      setStep(3);
    }
  }, [refCode]);

  return (
    <div>
      {step === 0 && (
        <PhoneLogin
          setStep={setStep}
          setIsLoginModal={setIsLoginModal}
          setPhone={setPhone}
        />
      )}
      {step === 1 && (
        <OtpLogin
          phone={phone}
          step={step}
          setStep={setStep}
          setIsLoginModal={setIsLoginModal}
          isRegister={isRegister}
        />
      )}
      {step === 3 && (
        <Register
          setStep={setStep}
          setIsLoginModal={setIsLoginModal}
          setPhone={setPhone}
          setIsRegister={setIsRegister}
          userInfo={userInfo}
          setUserInfo={setUserInfo}
          refCode={refCode || ""}
        />
      )}
      {step === 4 && (
        <LoginPassword setStep={setStep} setIsLoginModal={setIsLoginModal} />
      )}
    </div>
  );
}
