"use client";
import { CategoryType } from "@/@types/categorey";
import { userContext } from "@/app/context/UserProvider";
import CategoryLinkBox from "@/components/modules/CategoryLinkBox";
import { Button } from "@/components/ui/button";
import { getCategory } from "@/services/category";
import { useQuery } from "@tanstack/react-query";
import Image from "next/image";
import Link from "next/link";
import { useRouter } from "next/navigation";
import React, { Dispatch, SetStateAction, useContext, useState } from "react";
type SidebarProps = {
  isOpenSidebar: boolean;
  setIsOpenSidebar: Dispatch<SetStateAction<boolean>>;
  setIsLoginModal: Dispatch<SetStateAction<boolean>>;
};

export default function Sidebar({
  isOpenSidebar,
  setIsOpenSidebar,
  setIsLoginModal,
}: SidebarProps) {
  const router = useRouter();
  const user = useContext(userContext);

  const [isOpen, setIsOpen] = useState<boolean>(false);

  const { data: categorys } = useQuery({
    queryKey: ["category"],
    queryFn: getCategory,
    select: (res) => res.data.categorys,
  });
  function toggleDarkModeClass() {
    document.documentElement.classList.toggle("dark");
  }
  return (
    <div className="flex items-center">
      <div
        className={`${
          isOpenSidebar ? "translate-x-0" : "-translate-x-[230px]"
        } fixed top-0 left-0 z-[100] bg-light dark:bg-dark-500 w-[230px] h-full duration-300 overflow-auto`}
      >
        {/* <p onClick={() => setIsOpenSidebar((prev) => !prev)}>Sidebar</p> */}
        <div className="flex items-center justify-between pb-1 px-1 border-b  border-dark/15 dark:border-light/[6%]">
          <Image
            src={"/images/user-panel-logo.svg"}
            width={120}
            height={50}
            alt="عکس لوگو سایت"
            className="w-[90px] h-[50px]"
          />
          <svg
            className="size-5"
            onClick={() => setIsOpenSidebar((prev) => !prev)}
          >
            <use href="#x-mark"></use>
          </svg>
        </div>
        {user?.isLoading ? (
          <div className="flex items-center justify-center animate-pulse">
            <span className="inline-block w-20 h-9 lg:h-11 bg-neutral-150 border border-light-400 rounded-default "></span>
          </div>
        ) : user?.userInfo !== null ? (
          <div className="p-3 child:mx-1 w-full child:w-full child:my-1">
            <Button
              className="h-9 lg:h-11 bg-light hover:bg-light-200 text-neutral-700 border border-light-400 rounded-default"
              onClick={() => {
                router.push("/user-panel");
                setIsOpenSidebar(false);
              }}
            >
              پروفایل
            </Button>
            {user?.userInfo.role === "ADMIN" && (
              <Button
                className="h-9 lg:h-11 bg-primary-700/90 hover:bg-primary-700/80 text-light border border-primary-700 rounded-default"
                onClick={() => {
                  router.push("/admin-panel");
                  setIsOpenSidebar(false);
                }}
              >
                پنل ادمین
              </Button>
            )}
          </div>
        ) : (
          <div className="w-full  my-2 text-center">
            <Button
              className="h-9 lg:h-11 bg-light hover:bg-light-200 text-neutral-700 border border-light-400 rounded-default"
              onClick={() => {
                setIsLoginModal(true);
                setIsOpenSidebar((prev) => !prev);
              }}
            >
              ورود / ثبت نام
            </Button>
          </div>
        )}

        <ul className="p-2 space-y-4">
          <li className="mx-2" onClick={() => setIsOpenSidebar(false)}>
            <Link className="text-sm font-bold duration-150" href="/">
              صفحه اصلی
            </Link>
          </li>
          <ul
            className={`${
              isOpen ? "h-auto child:my-2" : "h-[22px] overflow-hidden"
            } mx-2`}
          >
            <div
              className="flex items-center justify-between text-sm font-bold duration-150 cursor-pointer"
              onClick={() => setIsOpen((prev) => !prev)}
            >
              <p>دسته بندی ها</p>
              <svg
                className={`size-3 ${
                  isOpen ? "-rotate-90 text-primary-700 duration-150" : ""
                }`}
              >
                <use href="#chevron-left"></use>
              </svg>
            </div>
            {categorys?.map((category: CategoryType) => (
              <CategoryLinkBox
                key={category._id}
                category={category}
                setIsOpenSidebar={setIsOpenSidebar}
              />
            ))}
          </ul>
          <li className="mx-2" onClick={() => setIsOpenSidebar(false)}>
            <Link className="text-sm font-bold duration-150" href="/about-us">
              درباه ما
            </Link>
          </li>
          <li className="mx-2" onClick={() => setIsOpenSidebar(false)}>
            <Link className="text-sm font-bold duration-150" href="/contact-us">
              تماس با ما
            </Link>
          </li>
        </ul>
        <div className="flex items-center gap-2 p-2 ">
          <Button
            className=" size-10 flex-center bg-secondary-default hover:bg-secondary-default/90 dark:text-light rounded-default"
            onClick={toggleDarkModeClass}
          >
            <svg
              xmlns="http://www.w3.org/2000/svg"
              fill="none"
              viewBox="0 0 24 24"
              strokeWidth={1.5}
              stroke="currentColor"
              className="size-6"
            >
              <path
                strokeLinecap="round"
                strokeLinejoin="round"
                d="M12 3v2.25m6.364.386-1.591 1.591M21 12h-2.25m-.386 6.364-1.591-1.591M12 18.75V21m-4.773-4.227-1.591 1.591M5.25 12H3m4.227-4.773L5.636 5.636M15.75 12a3.75 3.75 0 1 1-7.5 0 3.75 3.75 0 0 1 7.5 0Z"
              />
            </svg>
          </Button>

          <p>تغییر تم</p>
        </div>
      </div>
      <div
        className={`fixed top-0 left-0 w-full h-full z-[99] bg-neutral-800/60 backdrop-blur duration-100  ${
          isOpenSidebar ? "translate-x-0" : "-translate-x-[100%]"
        } `}
        onClick={() => setIsOpenSidebar((prev) => !prev)}
      ></div>
    </div>
  );
}
