import { Button } from "@/components/ui/button";
import Image from "next/image";
import Link from "next/link";

const SubscriptionBanner = () => {
  return (
    <section className="relative overflow-hidden mt-[100px] p-10 lg:h-[650px] md:h-[550px]">
      <div>
        <Image
          alt="circle"
          src="/images/circle.png"
          className="absolute blur-[160px] scale-[65%] -left-[350px] lg:-left-[150px] top-[50px]"
          height={300}
          width={500}
        />
      </div>

      <div>
        <Image
          alt="subs-logo-bg"
          src="/images/subs-logo-bg.png"
          className="absolute scale-[65%] top-[120px] hidden -right-[250px] lg:block"
          height={300}
          width={500}
        />
      </div>

      <div className="flex flex-col md:flex-row-reverse lg:mx-auto items-center justify-between max-w-[1108px]">
        <div className="z-10 flex flex-col md:w-[350px] ">
          <Image
            alt="person"
            src="/images/person-sm.png"
            height={300}
            width={500}
          />
          <div className="relative w-[300px] md:w-[350px] h-[70px] mx-auto m-0.5 sm:mt-2.75">
            <Image
              alt="txt-bg"
              src="/images/txt-bg.png"
              fill
              className="object-contain"
            />
            <h2 className="absolute inset-0 flex items-center justify-center gap-5 text-black text-center text-lg text-base-mines px-4">
              <span className="font-black text-xl lg:text-2xl font-peyda">
                {" "}
                200+{" "}
              </span>
              محصول متنوع در دسته بندی
            </h2>
          </div>
        </div>

        <div className="flex flex-col max-w-[500px] justify-center mt-[55px] gap-1">
          <h2 className="mx-auto font-peyda font-bold text-[30px] text-center">
            دانلود و اشتراک محصولات دیجیتال در
          </h2>
          <div className="mx-auto w-[216px] lg:w-[477px] h-[49px] lg:h-[97px] relative">
            <Image
              src="/images/logo.svg"
              alt="لوگو دارک بیت"
              fill
              className="object-contain lg:hidden"
            />
            <Image
              src="/images/logo-with-arrow.png"
              alt="لوگو دارک بیت"
              fill
              className="object-contain hidden lg:block"
            />
          </div>
          <div className="flex-center px-[10px] ">
            <p className=" mt-4 w-[352px] text-center text-base-mines">
              اینجا بازار محصولات دانلودیه، هر فایلی بخوای میتونی تو کمترین زمان
              از فروشگاه دارکوبیت تهیه کنی!
            </p>
          </div>
          <Link href={"/products"}>
            <Button className="bg-secondary-default hover:bg-secondary-default/90 rounded-[18px] mt-7 mx-auto px-6 py-6 h-[44px] w-[170px] flex gap-2 items-center">
              مشاهده محصولات
              <svg className="!size-6 shrink-0">
                <use href="#arrow-left"></use>
              </svg>
            </Button>
          </Link>
        </div>
      </div>
    </section>
  );
};

export default SubscriptionBanner;
