"use client";
import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";

import "swiper/css";
import "swiper/css/pagination";

import "./../../../styles/swiperStyles.css";

import { Pagination } from "swiper/modules";
import ShopCard from "@/components/modules/ShopCard";
import { useQuery } from "@tanstack/react-query";
import { getLatestProducts } from "@/services/produts";
import { file } from "@/@types/file";
export const DiscountedProductsSlider = () => {
  const { data: products, isLoading } = useQuery({
    queryKey: ["latest-products"],
    queryFn: getLatestProducts,
    select: (res) => res.data.files,
  });
  return (
    <>
      {isLoading ? (
        <div className="flex items-center justify-center gap-6 p-5 w-full h-[280px] lg:h-[372px] rounded-48 bg-neutral-150/20 animate-pulse">
          <div className="w-[200px] md:w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden lg:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden lg:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
          <div className="hidden xl:inline-block w-[288px] h-full rounded-48 bg-neutral-100/20"></div>
        </div>
      ) : (
        <Swiper
          // onSwiper={(swiper) => (swiperRef.current = swiper)}
          slidesPerView={1}
          spaceBetween={13}
          breakpoints={{
            640: {
              slidesPerView: 2,
              spaceBetween: 24,
            },
            768: {
              slidesPerView: 2,
              spaceBetween: 24,
            },
            1024: {
              slidesPerView: 3,
              spaceBetween: 26,
            },
            1280: {
              slidesPerView: 3,
              spaceBetween: 20,
            },
          }}
          modules={[Pagination]}
          className="mySwiper rounded !ml-2 cursor-pointer"
        >
          {products?.map((product: file) => (
            <SwiperSlide
              key={product._id}
              className="flex flex-col items-start justify-start !w-[248px]  lg:!w-[272px] md:!h-[280px] lg:!h-auto px-6 !bg-light dark:!bg-dark-500 rounded-48 "
            >
              <ShopCard productData={product} />
            </SwiperSlide>
          ))}
        </Swiper>
      )}
    </>
  );
};
