import Link from "next/link";
import React from "react";

export default function ContactFormRight() {
  return (
    <div className="w-full lg:min-w-[520px] bg-dark-600 py-7.5 px-9 rounded-20">
      <p className="pb-[18px] font-bold text-light text-2xl border-b border-primary-200">
        اطلاعات تماس
      </p>
      <div className="text-light mt-10">
        <div className="flex items-center gap-4">
          <svg className="size-5 text-primary-200">
            <use href="#map"></use>
          </svg>
          <p>آدرس:</p>
        </div>
        <p className="mr-8 mt-1.75">تهران، مینی سیتی، شهرک صدف، مجتمع آسمان</p>
      </div>
      <div className="text-light mt-10">
        <div className="flex items-center gap-4">
          <svg className="size-5 text-primary-200">
            <use href="#phone-solid"></use>
          </svg>
          <p>تماس:</p>
        </div>
        <p className="mr-8 mt-1.75"> 0933 456 789</p>
      </div>
      <div className="text-light mt-10">
        <div className="flex items-center gap-4">
          <svg className="size-5 text-primary-200">
            <use href="#envelope-solid"></use>
          </svg>
          <p>ایمیل:</p>
        </div>
        <p className="mr-8 mt-1.75">samplw@gmail.com</p>
      </div>

      <div className="flex items-center justify-between  mt-10 pt-10 text-light border-t border-primary-200">
        <p>شبکه های اجتماعی :</p>
        <div className="flex items-center gap-[22px]">
          <Link href={"https://www.instagram.com/darkoobit"} target="_blank">
            <svg className="size-6">
              <use href="#instagram"></use>
            </svg>
          </Link>
          <Link href={"https://t.me/darkoobit"} target="_blank">
            <svg className="size-6">
              <use href="#telegram"></use>
            </svg>
          </Link>
          <Link href="#">
            <svg className="size-6">
              <use href="#aparat"></use>
            </svg>
          </Link>
        </div>
      </div>
    </div>
  );
}
