import { FilterType } from "@/@types/filter";
import { Label } from "@/components/ui/label";
import { Switch } from "@/components/ui/switch";
import React, { Dispatch, SetStateAction } from "react";

type SwitchItemsProps = {
  filter: FilterType;
  setFilter: Dispatch<SetStateAction<FilterType>>;
};

export default function SwitchItems({ filter, setFilter }: SwitchItemsProps) {
  const availableProductHandler = (checked: boolean) => {
    setFilter((prev) => ({
      ...prev,
      onlyAvailable: checked,
    }));
  };
  const availableAmazingProductHandler = (checked: boolean) => {
    setFilter((prev) => ({
      ...prev,
      onlyAmazing: checked,
    }));
  };
  return (
    <div className="w-full pt-4 border-t border-dark/[7%] dark:border-light/10 space-y-[26px]">
      <div className="flex items-center justify-between w-full">
        <Label htmlFor="only-available-products">فقط کالا های موجود</Label>
        <Switch
          checked={filter?.onlyAvailable}
          onCheckedChange={availableProductHandler}
          dir="ltr"
          id="only-available-products"
        />
      </div>
      <div className="flex items-center justify-between w-full">
        <Label htmlFor="only-special-products">فقط محصولات ویژه</Label>
        <Switch
          checked={filter?.onlyAmazing}
          onCheckedChange={availableAmazingProductHandler}
          dir="ltr"
          id="only-special-products"
        />
      </div>
    </div>
  );
}
