import Link from "next/link";
import React, { useState } from "react";

export default function ShopAccordion() {
  const [isShow, setIsShow] = useState<boolean>(false);
  return (
    <div
      className={`${
        isShow ? "h-full" : "h-7"
      } my-[17px] overflow-hidden cursor-pointer`}
      onClick={() => setIsShow((prev) => !prev)}
    >
      <div className="flex items-center justify-between">
        <p className="text-sm">فروشگاه</p>
        <svg
          className={`${
            isShow ? "-rotate-90" : "rotate-0"
          } size-3 duration-150`}
        >
          <use href="#chevron-left"></use>
        </svg>
      </div>
      <ul className="mt-2 child:p-2 child:duration-150">
        <Link className="block hover:bg-muted" href="#">
          <li>فروشگاهی</li>
        </Link>
        <Link className="block hover:bg-muted" href="#">
          <li>فروشگاهی</li>
        </Link>
        <Link className="block hover:bg-muted" href="#">
          <li>فروشگاهی</li>
        </Link>
        <Link className="block hover:bg-muted" href="#">
          <li>فروشگاهی</li>
        </Link>
      </ul>
    </div>
  );
}
