import { SbuCategoryType } from "@/@types/categorey";
import { FilterType } from "@/@types/filter";
import { getSubCategory } from "@/services/category";
import { useQuery } from "@tanstack/react-query";
import React, { Dispatch, SetStateAction, useState } from "react";

type FileTypeFilterAccordionProps = {
  filter: FilterType;
  setFilter: Dispatch<SetStateAction<FilterType>>;
};

export default function FileTypeFilterAccordion({
  filter,
  setFilter,
}: FileTypeFilterAccordionProps) {
  const [isShow, setIsShow] = useState<boolean>(false);

  const { data: subCategories } = useQuery({
    queryKey: ["subCategory-filter"],
    queryFn: () => getSubCategory(filter?.categoryid),
    select: (res) => res.data?.subcategories,
  });

  const clickHandler = (subCatId: string) => {
    if (filter?.subcategoryid === subCatId) {
      setFilter((prev) => ({ ...prev, subcategoryid: "" }));
    } else {
      setFilter((prev) => ({ ...prev, subcategoryid: subCatId }));
    }
  };

  return (
    <div
      className={`${
        isShow ? "h-full" : "h-7"
      } my-[17px] overflow-hidden cursor-pointer`}
    >
      <div
        className="flex items-center justify-between"
        onClick={() => setIsShow((prev) => !prev)}
      >
        <p className="text-sm">زیر دسته</p>
        <svg
          className={`${
            isShow ? "-rotate-90" : "rotate-0"
          } size-3 duration-150`}
        >
          <use href="#chevron-left"></use>
        </svg>
      </div>
      <ul className="mt-2 child:p-2 child:duration-150">
        {subCategories?.map((subCat: SbuCategoryType) => (
          <li
            className={`${
              filter?.subcategoryid === subCat?._id
                ? " dark:text-dark h-full bg-primary-default "
                : " h-10 overflow-hidden hover:bg-primary-default/40 dark:hover:text-dark"
            }
            w-full px-1.5 my-1 rounded-10
              `}
            key={subCat?._id}
            onClick={() => clickHandler(subCat?._id)}
          >
            {subCat?.title}
          </li>
        ))}
      </ul>
    </div>
  );
}
