import { CategoryType } from "@/@types/categorey";
import { FilterType } from "@/@types/filter";
import { getCategory } from "@/services/category";
import { useQuery } from "@tanstack/react-query";
import React, { Dispatch, SetStateAction, useState } from "react";

type CategoryFilterAccordionProps = {
  filter: FilterType;
  setFilter: Dispatch<SetStateAction<FilterType>>;
};

export default function CategoryFilterAccordion({
  filter,
  setFilter,
}: CategoryFilterAccordionProps) {
  const [isShow, setIsShow] = useState<boolean>(false);

  const { data: categories } = useQuery({
    queryKey: ["category-filter"],
    queryFn: getCategory,
    select: (res) => res.data.categorys,
  });

  const clickHandler = (catId: string) => {
    if (filter?.categoryid === catId) {
      setFilter((prev) => ({ ...prev, categoryid: "", subcategoryid: "" }));
    } else {
      setFilter((prev) => ({ ...prev, categoryid: catId }));
    }
  };

  const subClickHandler = (subId: string) => {
    if (filter?.subcategoryid === subId) {
      setFilter((prev) => ({ ...prev, subcategoryid: "" }));
    } else {
      setFilter((prev) => ({ ...prev, subcategoryid: subId }));
    }
  };
  return (
    <div
      className={`${
        isShow ? "h-full" : "h-7"
      } my-[17px] overflow-hidden cursor-pointer`}
    >
      <div
        className="flex items-center justify-between"
        onClick={() => setIsShow((prev) => !prev)}
      >
        <p className="text-sm">دسته بندی ها</p>
        <svg
          className={`${
            isShow ? "-rotate-90" : "rotate-0"
          } size-3 duration-150`}
        >
          <use href="#chevron-left"></use>
        </svg>
      </div>
      <ul className="mt-2 child:p-2 child:duration-150 space-y-1">
        {categories?.map((category: CategoryType) => (
          <li
            className={`${
              filter?.categoryid === category?._id
                ? "dark:text-dark h-full"
                : " h-10 overflow-hidden hover:bg-primary-default dark:hover:text-dark"
            }
            w-full px-1.5 rounded-10
              `}
            key={category?._id}
          >
            <div
              className={`flex items-center justify-between ${
                filter?.categoryid === category?._id
                  ? "bg-primary-default/70 rounded-10 p-2"
                  : ""
              } `}
              onClick={() => clickHandler(category?._id)}
            >
              {category?.title}
              <svg
                className={`${
                  filter?.categoryid === category?._id
                    ? "-rotate-90"
                    : "rotate-0"
                } size-2.5 duration-150`}
              >
                <use href="#chevron-left"></use>
              </svg>
            </div>
            <ul
              className={`w-[full] p-1 mx-2.5 md:mx-1 mt-1.5 child:w-full bg-neutral-100/10 rounded-9 ${
                filter?.categoryid === category?._id ? "inline-block" : "hidden"
              }`}
            >
              {category?.subcategories?.map((sub) => (
                <li
                  className={`${
                    filter?.subcategoryid === sub?._id
                      ? "bg-primary-default rounded-10 dark:text-dark"
                      : "hover:bg-primary-default/40 dark:hover:text-dark rounded-10 dark:text-light"
                  } inline-block p-2 pr-4 my-0.5 text-sm`}
                  key={sub?._id}
                  onClick={() => subClickHandler(sub?._id)}
                >
                  {sub.title}
                </li>
              ))}
            </ul>
          </li>
        ))}
      </ul>
    </div>
  );
}
