import Image from "next/image";
import React from "react";

export default function CategoryBanner({
  catName,
  subName,
}: {
  catName: string;
  subName?: string;
}) {
  const category = decodeURIComponent(catName ?? "");
  const subCategory = decodeURIComponent(subName ?? "");

  return (
    <section className="relative w-full h-[138px] mt-[42px] mb-10 bg-secondary-default dark:bg-[#222222] rounded">
      <Image
        src={"/images/banner-pattern.png"}
        alt="عکس بک گراند"
        width={1200}
        height={138}
        className="w-full h-full"
      />
      <p className="absolute top-[38px] w-full text-light text-xl text-center font-black">
        فایل های طراحی سایت
      </p>
      <div className="absolute top-[75px] flex-center md:gap-3 w-full px-1 text-light/60 text-xs md:text-base">
        <p className="line-clamp-1">{category}</p>
        {subCategory && (
          <>
            <svg className="size-3">
              <use href="#chevron-left"></use>
            </svg>
            <p className="line-clamp-1">{subCategory}</p>
          </>
        )}
      </div>
    </section>
  );
}
