"use client";
import { FilterBlogType } from "@/@types/filter";
import { SortValueType } from "@/@types/sort";
import { sortLabels } from "@/lib/constants";
import React, { Dispatch, SetStateAction, useEffect, useState } from "react";

type BlogSortProps = {
  filter: FilterBlogType;
  setFilter: Dispatch<SetStateAction<FilterBlogType>>;
};

export default function BlogSort({ filter, setFilter }: BlogSortProps) {
  const [isShow, setIsShow] = useState<boolean>(false);
  const [sortValue, seSortValue] = useState<SortValueType>("-1");

  // eslint-disable-next-line react-hooks/exhaustive-deps
  useEffect(() => {
    if (sortValue !== "-1") {
      // setFilter((prev) => ({ ...prev, sort: "" }));

      setFilter((prev) => ({ ...prev, sort: sortValue }));
    }
  }, [sortValue]);
  return (
    <div className="flex items-center justify-end mb-3 lg:mb-0 ">
      <div
        className="relative flex items-center justify-between sm:justify-normal gap-[19px] px-2.25 py-1.25 w-full sm:w-auto bg-light dark:bg-[#393939] text-[#676767] dark:text-light rounded-md border border-[#F2F2F2] dark:border-[#4E4E4E] cursor-pointer"
        onClick={() => setIsShow((prev) => !prev)}
      >
        <p className="w-[110px] text-sm-mines">{sortLabels[sortValue]}</p>
        <svg className="size-3">
          <use href="#chevron-down"></use>
        </svg>
        {isShow && (
          <ul className="absolute top-8 right-0 w-full p-2.5 bg-light dark:bg-[#2c2c2c] space-y-1 border border-[#F2F2F2] dark:border-[#4E4E4E] shadow-md rounded-lg z-40">
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "" ? "bg-light-300 dark:bg-[#393939]" : ""
              }`}
              onClick={() => seSortValue("-1")}
            >
              مرتب سازی بر اساس
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "newest"
                  ? "bg-light-300 dark:bg-[#393939]"
                  : ""
              }`}
              onClick={() => seSortValue("newest")}
            >
              جدیدترین
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "oldest"
                  ? "bg-light-300 dark:bg-[#393939]"
                  : ""
              }`}
              onClick={() => seSortValue("oldest")}
            >
              قدیمی ترین
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "expensive"
                  ? "bg-light-300 dark:bg-[#393939]"
                  : ""
              }`}
              onClick={() => seSortValue("expensive")}
            >
              بیشترین قیمت
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "cheap" ? "bg-light-300 dark:bg-[#393939]" : ""
              }`}
              onClick={() => seSortValue("cheap")}
            >
              کمترین قیمت
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "bestselling"
                  ? "bg-light-300 dark:bg-[#393939]"
                  : ""
              }`}
              onClick={() => seSortValue("bestselling")}
            >
              پرفروش ترین
            </li>
            <li
              className={`p-1.5 hover:bg-light-300 hover:dark:bg-[#393939] text-sm-mines cursor-pointer ${
                filter?.sort === "max-discount"
                  ? "bg-light-300 dark:bg-[#393939]"
                  : ""
              }`}
              onClick={() => seSortValue("max-discount")}
            >
              بیشترین تخفیف
            </li>
          </ul>
        )}
      </div>
    </div>
  );
}
