"use client";

import React, { useMemo } from "react";

import { getTicket } from "@/services/tickets";
import { useQuery } from "@tanstack/react-query";
import { TicketType } from "@/@types/tickets";
import { ApiResponse } from "@/@types/api";
import AdminTicketChatInput from "./AdminTicketChatInput";
type MsgItem = {
  _id: string;
  text: string;
  time: number;
  sender: "user" | "admin";
};
export default function AdminTicketChatBox({ ticketId }: { ticketId: string }) {
  const { data: ticket, isLoading } = useQuery<ApiResponse<TicketType>>({
    queryKey: ["ticket", ticketId],
    queryFn: () => getTicket(ticketId),
  });
  const sortedMessages: MsgItem[] = useMemo(() => {
    if (!ticket?.data) return [];

    const userMsgs = (ticket.data.masssge || []).map((msg) => ({
      _id: msg._id,
      text: msg.text,
      time: new Date(msg.time).getTime(),
      sender: "user" as const,
    }));

    const adminMsgs = (ticket.data.masssgeadmin || []).map((msg) => ({
      _id: msg._id,
      text: msg.text,
      time: new Date(msg.time).getTime(),
      sender: "admin" as const,
    }));

    return [...userMsgs, ...adminMsgs].sort((a, b) => a.time - b.time);
  }, [ticket]);

  return (
    <section className="flex flex-col gap-y-3 w-full my-3">
      {isLoading ? (
        <>
          <div className="w-full h-20 md:w-3/4 p-3.5 whitespace-break-spaces border rounded-md bg-[#eeeeee] dark:bg-[#494949] text-dark dark:text-white/90 border-[#EBEBEB] dark:border-neutral-500/50 text-sm leading-7 animate-pulse"></div>
          <div className="flex justify-end w-full">
            <div className="w-full h-20 md:w-3/4 p-3.5 whitespace-break-spaces border rounded-md bg-[#3D96D1]/[12%] dark:bg-[#196aa0]/[12%] text-dark dark:text-white/90 border-[#EBEBEB] dark:border-neutral-500/50 text-sm leading-7 animate-pulse"></div>
          </div>
        </>
      ) : (
        <>
          {" "}
          {sortedMessages.map((msg) => (
            <div
              key={msg._id}
              className={`flex flex-col gap-2.5 ${
                msg.sender === "user" ? "items-start" : "items-end"
              }`}
            >
              <div
                className={`w-full md:w-3/4 p-3.5 whitespace-break-spaces border rounded-md ${
                  msg.sender === "user"
                    ? "bg-[#f7f7f7] dark:bg-[#2e2e2e] text-dark dark:text-light/80 border-[#EBEBEB] dark:border-neutral-500/50"
                    : "bg-[#3D96D1]/[12%] dark:bg-[#196aa0] text-dark dark:text-white/90 border-[#EBEBEB] dark:border-neutral-500/50 text-sm leading-7"
                }`}
              >
                {msg.text}
              </div>
              <div
                className={`flex items-center gap-1.5 text-xs text-right ${
                  msg.sender === "user"
                    ? "justify-start text-[#8f8e8e] dark:text-light/8"
                    : "justify-start text-[#8f8e8e] dark:text-light/8 w-full md:w-3/4"
                }`}
              >
                <p>{msg.sender === "user" ? "شما" : "پشتیبانی"}</p>
                <span className="size-1 rounded-full bg-[#a3a3a3]"></span>
                <p>
                  {new Date(msg.time).toLocaleTimeString("fa-IR", {
                    hour: "2-digit",
                    minute: "2-digit",
                  })}
                </p>
              </div>
            </div>
          ))}
          {ticket?.data.status === "close" && (
            <div className="flex items-center justify-end w-full mt-2.5">
              <div className="w-full md:w-3/4 p-3.5 whitespace-break-spaces border rounded-md bg-[#3D96D1]/[12%] dark:bg-[#196aa0] text-dark dark:text-white/90 border-[#EBEBEB] dark:border-neutral-500/50 text-sm leading-7">
                این تیکت بصورت اتوماتیک بسته شده است
              </div>
            </div>
          )}
          {ticket?.data.status === "open" && (
            <AdminTicketChatInput ticketId={ticket?.data._id} />
          )}
        </>
      )}
    </section>
  );
}
