"use client";

import LoadingBox from "@/components/modules/LoadingBox";
import { Button } from "@/components/ui/button";
import { getAdminSubSubCategory } from "@/services/category";
import { useQuery } from "@tanstack/react-query";
import Image from "next/image";
import React, { useState } from "react";
import { CategoryType } from "@/@types/categorey";
import DeleteModal from "./DeleteModal";
import EditModal from "./EditModal";

type SubSubcategoriesTableProps = {
  subId: string;
  catId: string;
};

export default function SubSubcategoriesTable({
  subId,
  catId,
}: SubSubcategoriesTableProps) {
  const [isOpenDeleteModal, setIsOpenDeleteModal] = useState<boolean>(false);
  const [isOpenEditModal, setIsOpenEditModal] = useState<boolean>(false);
  const [subSubId, setSubSubId] = useState<string>("");
  const { data, isLoading } = useQuery({
    queryKey: ["admin-sub-sub-category", subId],
    queryFn: () => getAdminSubSubCategory({ catId, subId }),
    select: (res) => res.data,
  });
  if (isLoading) return <LoadingBox />;
  return (
    <>
      <table className="w-full mt-7">
        <thead>
          <tr className="child:text-center child:text-[#454545] dark:child:text-light/80 child:text-sm">
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عکس
            </th>
            <th className="pb-3.25 border-b border-dark/[7%] dark:border-light/[6%]">
              نام دسته بندی
            </th>
            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              مسیر (url)
            </th>

            <th className="pb-3.25 !text-center border-b border-dark/[7%] dark:border-light/[6%]">
              عملیات
            </th>
          </tr>
        </thead>
        <tbody className="divide-y divide-dark/[7%] dark:divide-light/[6%]">
          {data.subsubcategories?.map((category: CategoryType) => (
            <tr
              key={category._id}
              className=" child:py-[30px] child:px-2 child:text-center"
            >
              <td>
                <Image
                  src={`${process.env.NEXT_PUBLIC_BASE_URL}${category.img}`}
                  alt={category.title}
                  width={200}
                  height={200}
                  className="w-[100px] h-[100px] mx-auto"
                />
              </td>
              <td>
                <p className="text-[#575757] dark:text-light/80 text-sm">
                  {category.title}
                </p>
              </td>
              <td>
                <p className="text-[#575757] dark:text-light/80 text-sm">
                  {category.href}
                </p>
              </td>

              <td className="child:mx-1">
                <Button
                  className="inline-block mx-auto p-2.5 bg-primary-700 hover:bg-primary-700/90 duration-150 child:text-white text-xs rounded-md"
                  onClick={() => {
                    setSubSubId(category._id);
                    setIsOpenEditModal(true);
                  }}
                >
                  <p>ویرایش</p>
                </Button>
                <Button
                  className="inline-block mx-auto p-2.5 bg-[#FF0000] hover:bg-[#FF0000]/80 duration-150 text-white text-xs font-bold rounded-md"
                  onClick={() => {
                    setSubSubId(category._id);
                    setIsOpenDeleteModal(true);
                  }}
                >
                  حذف
                </Button>
              </td>
            </tr>
          ))}
        </tbody>
      </table>
      {isOpenDeleteModal && (
        <DeleteModal
          categoryId={catId}
          subCategoryId={subId}
          subSubId={subSubId}
          keyValue={["admin-sub-sub-category", subId]}
          setIsOpenDeleteModal={setIsOpenDeleteModal}
        />
      )}
      {isOpenEditModal && (
        <EditModal
          subsubId={subSubId}
          setIsOpenEditModal={setIsOpenEditModal}
        />
      )}
    </>
  );
}
