import React, { Dispatch, SetStateAction } from "react";
import UpdateFileForm from "./UpdateFileForm";
import { file } from "@/@types/file";

type EditModalProps = {
  setIsOpenEditModal: Dispatch<SetStateAction<boolean>>;
  data: file | null;
};

export default function EditModal({
  setIsOpenEditModal,
  data,
}: EditModalProps) {
  return (
    <div className="fixed inset-0 flex items-center justify-center mx-auto w-screen h-screen overflow-hidden animate-fadeIn z-[100]">
      <div className="w-[350px] md:w-[400px]w-[350px] md:w-[90%] h-[90%] p-3 bg-light dark:bg-dark-400 rounded-10 z-50 overflow-auto">
        <div>
          <p className="font-bold text-xl text-[#001A46] dark:text-light">
            ویرایش محصول
          </p>
          <div className="flex items-center mt-4">
            <span className="w-[25%] h-0.5 bg-secondary-default dark:bg-primary-200"></span>
            <span className="w-[75%] h-0.5 bg-dark/[7%] dark:bg-[#4A4A4A]"></span>
          </div>
        </div>
        <UpdateFileForm
          fileData={data}
          setIsOpenEditModal={setIsOpenEditModal}
        />
      </div>

      <div
        className="absolute w-full h-full z-40"
        onClick={() => {
          setIsOpenEditModal(false);
        }}
      ></div>
    </div>
  );
}
